/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.main;

import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.ServerAnimator;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.property.JointMaskReloadListener;
import yesman.epicfight.api.client.model.ItemSkins;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.data.reloader.ItemCapabilityReloadListener;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.gui.screen.config.IngameConfigurationScreen;
import yesman.epicfight.client.renderer.patched.item.EpicFightItemProperties;
import yesman.epicfight.compat.AzureLibArmorCompat;
import yesman.epicfight.compat.AzureLibCompat;
import yesman.epicfight.compat.CuriosCompat;
import yesman.epicfight.compat.FirstPersonCompat;
import yesman.epicfight.compat.GeckolibCompat;
import yesman.epicfight.compat.ICompatModule;
import yesman.epicfight.compat.IRISCompat;
import yesman.epicfight.compat.SkinLayer3DCompat;
import yesman.epicfight.config.ConfigManager;
import yesman.epicfight.config.EpicFightOptions;
import yesman.epicfight.data.conditions.EpicFightConditions;
import yesman.epicfight.data.loot.EpicFightLootTables;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.main.EpicFightExtensions;
import yesman.epicfight.network.EpicFightDataSerializers;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.server.commands.PlayerModeCommand;
import yesman.epicfight.server.commands.PlayerSkillCommand;
import yesman.epicfight.server.commands.arguments.EpicFightCommandArgumentTypes;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.capabilities.item.WeaponTypeReloadListener;
import yesman.epicfight.world.capabilities.provider.EntityPatchProvider;
import yesman.epicfight.world.capabilities.provider.ItemCapabilityProvider;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.effect.EpicFightPotions;
import yesman.epicfight.world.entity.EpicFightEntities;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.decoration.EpicFightPaintingVariants;
import yesman.epicfight.world.gamerule.EpicFightGamerules;
import yesman.epicfight.world.item.EpicFightCreativeTabs;
import yesman.epicfight.world.item.EpicFightItems;
import yesman.epicfight.world.item.SkillBookItem;
import yesman.epicfight.world.level.block.EpicFightBlocks;
import yesman.epicfight.world.level.block.entity.EpicFightBlockEntities;

@Mod(value="epicfight")
public class EpicFightMod {
    public static final String MODID = "epicfight";
    public static final String CONFIG_FILE_PATH = "epicfight.toml";
    public static final Logger LOGGER = LogManager.getLogger((String)"epicfight");
    public static EpicFightOptions CLIENT_CONFIGS;
    private static EpicFightMod instance;
    private Function<LivingEntityPatch<?>, Animator> animatorProvider;

    public static EpicFightMod getInstance() {
        return instance;
    }

    public EpicFightMod() {
        instance = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigManager.CLIENT_CONFIG);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::constructMod);
        bus.addListener(this::doCommonStuff);
        bus.addListener(this::addPackFindersEvent);
        bus.addListener(this::buildCreativeTabWithSkillBooks);
        bus.addListener(SkillManager::createSkillRegistry);
        bus.addListener(SkillManager::registerSkills);
        bus.addListener(EpicFightCapabilities::registerCapabilities);
        bus.addListener(EpicFightEntities::onSpawnPlacementRegister);
        MinecraftForge.EVENT_BUS.addListener(this::command);
        MinecraftForge.EVENT_BUS.addListener(this::addReloadListnerEvent);
        LivingMotion.ENUM_MANAGER.registerEnumCls(MODID, LivingMotions.class);
        SkillCategory.ENUM_MANAGER.registerEnumCls(MODID, SkillCategories.class);
        SkillSlot.ENUM_MANAGER.registerEnumCls(MODID, SkillSlots.class);
        Style.ENUM_MANAGER.registerEnumCls(MODID, CapabilityItem.Styles.class);
        WeaponCategory.ENUM_MANAGER.registerEnumCls(MODID, CapabilityItem.WeaponCategories.class);
        EpicFightMobEffects.EFFECTS.register(bus);
        EpicFightPotions.POTIONS.register(bus);
        EpicFightAttributes.ATTRIBUTES.register(bus);
        EpicFightCreativeTabs.TABS.register(bus);
        EpicFightItems.ITEMS.register(bus);
        EpicFightParticles.PARTICLES.register(bus);
        EpicFightEntities.ENTITIES.register(bus);
        EpicFightBlocks.BLOCKS.register(bus);
        EpicFightBlockEntities.BLOCK_ENTITIES.register(bus);
        EpicFightLootTables.LOOT_MODIFIERS.register(bus);
        EpicFightSounds.SOUNDS.register(bus);
        EpicFightDataSerializers.ENTITY_DATA_SERIALIZER.register(bus);
        EpicFightConditions.CONDITIONS.register(bus);
        SkillDataKeys.DATA_KEYS.register(bus);
        EpicFightPaintingVariants.PAINTING_VARIANTS.register(bus);
        EpicFightCommandArgumentTypes.COMMAND_ARGUMENT_TYPES.register(bus);
        ConfigManager.loadConfig(ConfigManager.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("epicfight-client.toml").toString());
        ConfigManager.loadConfig(ConfigManager.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve(CONFIG_FILE_PATH).toString());
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(IngameConfigurationScreen::new));
        ModLoadingContext.get().registerExtensionPoint(EpicFightExtensions.class, () -> new EpicFightExtensions((CreativeModeTab)EpicFightCreativeTabs.ITEMS.get()));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (ModList.get().isLoaded("geckolib")) {
                ICompatModule.loadCompatModule(GeckolibCompat.class);
            }
            if (ModList.get().isLoaded("azurelib")) {
                ICompatModule.loadCompatModule(AzureLibCompat.class);
            }
            if (ModList.get().isLoaded("azurelibarmor")) {
                ICompatModule.loadCompatModule(AzureLibArmorCompat.class);
            }
            if (ModList.get().isLoaded("curios")) {
                ICompatModule.loadCompatModule(CuriosCompat.class);
            }
            if (ModList.get().isLoaded("firstperson")) {
                ICompatModule.loadCompatModule(FirstPersonCompat.class);
            }
            if (ModList.get().isLoaded("skinlayers3d")) {
                ICompatModule.loadCompatModule(SkinLayer3DCompat.class);
            }
            if (ModList.get().isLoaded("oculus")) {
                ICompatModule.loadCompatModule(IRISCompat.class);
            }
        });
    }

    private void constructMod(FMLConstructModEvent event) {
        LivingMotion.ENUM_MANAGER.loadEnum();
        SkillCategory.ENUM_MANAGER.loadEnum();
        SkillSlot.ENUM_MANAGER.loadEnum();
        Style.ENUM_MANAGER.loadEnum();
        WeaponCategory.ENUM_MANAGER.loadEnum();
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        event.enqueueWork(EpicFightCommandArgumentTypes::registerArgumentTypes);
        event.enqueueWork(EpicFightPotions::addRecipes);
        event.enqueueWork(EpicFightNetworkManager::registerPackets);
        event.enqueueWork(ItemCapabilityProvider::registerWeaponTypesByClass);
        event.enqueueWork(EntityPatchProvider::registerEntityPatches);
        event.enqueueWork(EpicFightGamerules::registerRules);
        event.enqueueWork(WeaponTypeReloadListener::registerDefaultWeaponTypes);
        event.enqueueWork(EpicFightMobEffects::addOffhandModifier);
        event.enqueueWork(EpicFightLootTables::registerLootItemFunctionType);
    }

    private void command(RegisterCommandsEvent event) {
        PlayerModeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PlayerSkillCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    public void addPackFindersEvent(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/epicfight_legacy"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + resourcePath, resourcePath, false);
            Pack.ResourcesSupplier resourcesSupplier = string -> pack;
            Pack.Info info = Pack.m_246334_((String)"epicfight_legacy", (Pack.ResourcesSupplier)resourcesSupplier);
            if (info != null) {
                event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)"epicfight_legacy", (Component)Component.m_237115_((String)"pack.epicfight_legacy.title"), (boolean)false, (Pack.ResourcesSupplier)resourcesSupplier, (Pack.Info)info, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
            }
        }
    }

    private void addReloadListnerEvent(AddReloadListenerEvent event) {
        if (!EpicFightMod.isPhysicalClient()) {
            event.addListener((PreparableReloadListener)AnimationManager.getInstance());
        }
        event.addListener((PreparableReloadListener)new ColliderPreset());
        event.addListener((PreparableReloadListener)new SkillManager());
        event.addListener((PreparableReloadListener)new WeaponTypeReloadListener());
        event.addListener((PreparableReloadListener)new ItemCapabilityReloadListener());
        event.addListener((PreparableReloadListener)new MobPatchReloadListener());
    }

    private void buildCreativeTabWithSkillBooks(BuildCreativeModeTabContentsEvent event) {
        SkillManager.getNamespaces().forEach(modid -> ModList.get().getModContainerById(modid).flatMap(mc -> mc.getCustomExtension(EpicFightExtensions.class)).ifPresentOrElse(extension -> {
            if (extension.skillBookCreativeTab() == event.getTab()) {
                SkillManager.getSkillNames(skill -> skill.getCategory().learnable() && skill.getRegistryName().m_135827_() == modid).forEach(rl -> {
                    ItemStack stack = new ItemStack((ItemLike)EpicFightItems.SKILLBOOK.get());
                    SkillBookItem.setContainingSkill(rl.toString(), stack);
                    event.m_246342_(stack);
                });
            }
        }, () -> {
            if (event.getTab() == EpicFightCreativeTabs.ITEMS.get()) {
                SkillManager.getSkillNames(skill -> skill.getCategory().learnable() && skill.getRegistryName().m_135827_() == modid).forEach(rl -> {
                    ItemStack stack = new ItemStack((ItemLike)EpicFightItems.SKILLBOOK.get());
                    SkillBookItem.setContainingSkill(rl.toString(), stack);
                    event.m_246342_(stack);
                });
            }
        }));
    }

    public static Animator getAnimator(LivingEntityPatch<?> entitypatch) {
        return EpicFightMod.getInstance().animatorProvider.apply(entitypatch);
    }

    public static boolean isPhysicalClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    @Mod.EventBusSubscriber(modid="epicfight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.DEDICATED_SERVER})
    public static class ServerModEvents {
        @SubscribeEvent
        public static void doServerStuff(FMLDedicatedServerSetupEvent event) {
            EpicFightMod.getInstance().animatorProvider = ServerAnimator::getAnimator;
        }
    }

    @Mod.EventBusSubscriber(modid="epicfight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            CLIENT_CONFIGS = new EpicFightOptions();
            new ClientEngine();
            EpicFightMod.getInstance().animatorProvider = ClientAnimator::getAnimator;
            EntityPatchProvider.registerEntityPatchesClient();
            SkillBookScreen.registerIconItems();
            EpicFightItemProperties.registerItemProperties();
        }

        @SubscribeEvent
        public static void registerResourcepackReloadListnerEvent(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)new JointMaskReloadListener());
            event.registerReloadListener((PreparableReloadListener)Meshes.INSTANCE);
            event.registerReloadListener((PreparableReloadListener)AnimationManager.getInstance());
            event.registerReloadListener((PreparableReloadListener)ItemSkins.INSTANCE);
        }
    }
}

