/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.gameasset;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.forgeevent.ModelBuildEvent;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.model.JsonModelLoader;
import yesman.epicfight.model.armature.CreeperArmature;
import yesman.epicfight.model.armature.DragonArmature;
import yesman.epicfight.model.armature.EndermanArmature;
import yesman.epicfight.model.armature.HoglinArmature;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.model.armature.IronGolemArmature;
import yesman.epicfight.model.armature.PiglinArmature;
import yesman.epicfight.model.armature.RavagerArmature;
import yesman.epicfight.model.armature.SpiderArmature;
import yesman.epicfight.model.armature.VexArmature;
import yesman.epicfight.model.armature.WitherArmature;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.entity.EpicFightEntities;

public class Armatures {
    public static final Armatures INSTANCE = new Armatures();
    private static final BiMap<ResourceLocation, Armature> ARMATURES = HashBiMap.create();
    private static final Map<EntityType<?>, Function<EntityPatch<?>, Armature>> ENTITY_TYPE_ARMATURE = Maps.newHashMap();
    public static HumanoidArmature BIPED;
    public static CreeperArmature CREEPER;
    public static EndermanArmature ENDERMAN;
    public static HumanoidArmature SKELETON;
    public static SpiderArmature SPIDER;
    public static IronGolemArmature IRON_GOLEM;
    public static RavagerArmature RAVAGER;
    public static VexArmature VEX;
    public static PiglinArmature PIGLIN;
    public static HoglinArmature HOGLIN;
    public static DragonArmature DRAGON;
    public static WitherArmature WITHER;

    public static void build(ResourceManager resourceManager) {
        ARMATURES.clear();
        ModelBuildEvent.ArmatureBuild event = new ModelBuildEvent.ArmatureBuild(resourceManager, (Map<ResourceLocation, Armature>)ARMATURES);
        BIPED = event.get("epicfight", "entity/biped", HumanoidArmature::new);
        CREEPER = event.get("epicfight", "entity/creeper", CreeperArmature::new);
        ENDERMAN = event.get("epicfight", "entity/enderman", EndermanArmature::new);
        SKELETON = event.get("epicfight", "entity/skeleton", HumanoidArmature::new);
        SPIDER = event.get("epicfight", "entity/spider", SpiderArmature::new);
        IRON_GOLEM = event.get("epicfight", "entity/iron_golem", IronGolemArmature::new);
        RAVAGER = event.get("epicfight", "entity/ravager", RavagerArmature::new);
        VEX = event.get("epicfight", "entity/vex", VexArmature::new);
        PIGLIN = event.get("epicfight", "entity/piglin", PiglinArmature::new);
        HOGLIN = event.get("epicfight", "entity/hoglin", HoglinArmature::new);
        DRAGON = event.get("epicfight", "entity/dragon", DragonArmature::new);
        WITHER = event.get("epicfight", "entity/wither", WitherArmature::new);
        Armatures.registerEntityTypeArmature(EntityType.f_20554_, SPIDER);
        Armatures.registerEntityTypeArmature(EntityType.f_20558_, CREEPER);
        Armatures.registerEntityTypeArmature(EntityType.f_20562_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20566_, ENDERMAN);
        Armatures.registerEntityTypeArmature(EntityType.f_20568_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20456_, HOGLIN);
        Armatures.registerEntityTypeArmature(EntityType.f_20458_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20460_, IRON_GOLEM);
        Armatures.registerEntityTypeArmature(EntityType.f_20512_, PIGLIN);
        Armatures.registerEntityTypeArmature(EntityType.f_20511_, PIGLIN);
        Armatures.registerEntityTypeArmature(EntityType.f_20513_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20518_, RAVAGER);
        Armatures.registerEntityTypeArmature(EntityType.f_20524_, SKELETON);
        Armatures.registerEntityTypeArmature(EntityType.f_20479_, SPIDER);
        Armatures.registerEntityTypeArmature(EntityType.f_20481_, SKELETON);
        Armatures.registerEntityTypeArmature(EntityType.f_20491_, VEX);
        Armatures.registerEntityTypeArmature(EntityType.f_20493_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20495_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20497_, SKELETON);
        Armatures.registerEntityTypeArmature(EntityType.f_20500_, HOGLIN);
        Armatures.registerEntityTypeArmature(EntityType.f_20501_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20530_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20531_, PIGLIN);
        Armatures.registerEntityTypeArmature(EntityType.f_20532_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20565_, DRAGON);
        Armatures.registerEntityTypeArmature(EntityType.f_20496_, WITHER);
        Armatures.registerEntityTypeArmature((EntityType)EpicFightEntities.WITHER_SKELETON_MINION.get(), SKELETON);
        Armatures.registerEntityTypeArmature((EntityType)EpicFightEntities.WITHER_GHOST_CLONE.get(), WITHER);
        ModLoader.get().postEvent((Event)event);
    }

    public static void registerEntityTypeArmature(EntityType<?> entityType, Armature armature) {
        ENTITY_TYPE_ARMATURE.put(entityType, entitypatch -> armature.deepCopy());
    }

    public static void registerEntityTypeArmature(EntityType<?> entityType, String presetName) {
        EntityType presetEntityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(presetName));
        ENTITY_TYPE_ARMATURE.put(entityType, ENTITY_TYPE_ARMATURE.get(presetEntityType));
    }

    public static void registerEntityTypeArmature(EntityType<?> entityType, Function<EntityPatch<?>, Armature> armatureGetFunction) {
        ENTITY_TYPE_ARMATURE.put(entityType, armatureGetFunction);
    }

    public static <A extends Armature> A getArmatureFor(EntityPatch<?> entitypatch) {
        return (A)ENTITY_TYPE_ARMATURE.get(entitypatch.getOriginal().m_6095_()).apply(entitypatch).deepCopy();
    }

    public static ResourceLocation getKey(Armature armature) {
        return (ResourceLocation)ARMATURES.inverse().get((Object)armature);
    }

    public static Armature getArmatureOrNull(ResourceLocation rl) {
        return (Armature)ARMATURES.get((Object)rl);
    }

    public static void addArmature(ResourceLocation rl, Armature armature) {
        ARMATURES.put((Object)rl, (Object)armature);
    }

    public static Function<EntityPatch<?>, Armature> getRegistry(EntityType<?> entityType) {
        return ENTITY_TYPE_ARMATURE.get(entityType);
    }

    public static <A extends Armature> A getOrCreateArmature(ResourceManager rm, ResourceLocation rl, ArmatureContructor<A> constructor) {
        return (A)((Armature)ARMATURES.computeIfAbsent((Object)rl, key -> {
            JsonModelLoader jsonModelLoader = new JsonModelLoader(rm, Armatures.wrapLocation(rl));
            return jsonModelLoader.loadArmature(constructor);
        }));
    }

    public static Set<Map.Entry<ResourceLocation, Armature>> entries() {
        return ARMATURES.entrySet();
    }

    public static ResourceLocation wrapLocation(ResourceLocation rl) {
        return rl.m_135815_().matches("animmodels/.*\\.json") ? rl : new ResourceLocation(rl.m_135827_(), "animmodels/" + rl.m_135815_() + ".json");
    }

    @FunctionalInterface
    public static interface ArmatureContructor<T extends Armature> {
        public T invoke(String var1, int var2, Joint var3, Map<String, Joint> var4);
    }
}

