/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.conditions.entity;

import io.netty.util.internal.StringUtil;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.widgets.PopupBox;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class PlayerSkillActivated
extends Condition.EntityPatchCondition {
    private Skill skill;

    public PlayerSkillActivated read(CompoundTag tag) {
        if (!tag.m_128441_("skill") || StringUtil.isNullOrEmpty((String)tag.m_128461_("skill"))) {
            throw new IllegalArgumentException("Undefined skill");
        }
        this.skill = SkillManager.getSkill(tag.m_128461_("skill"));
        return this;
    }

    @Override
    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("skill", this.skill.getRegistryName().toString());
        return tag;
    }

    @Override
    public boolean predicate(LivingEntityPatch<?> target) {
        if (target instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)target;
            SkillContainer skill = playerpatch.getSkill(this.skill);
            if (skill == null) {
                return false;
            }
            return skill.isActivated();
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        PopupBox.RegistryPopupBox<Skill> popupBox = new PopupBox.RegistryPopupBox<Skill>(screen, screen.getMinecraft().f_91062_, 0, 0, 0, 0, null, null, (Component)Component.m_237113_((String)"skill"), SkillManager.getSkillRegistry(), null);
        return List.of(Condition.ParameterEditor.of(skill -> StringTag.m_129297_((String)skill.toString()), tag -> SkillManager.getSkill(ParseUtil.nullOrToString(tag, Tag::m_7916_)), popupBox));
    }
}

