/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.StuckInBodyLayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public abstract class PatchedStuckInBodyLayer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends PlayerModel<E>, R extends StuckInBodyLayer<E, M>>
extends PatchedLayer<E, T, M, R> {
    @Override
    protected void renderLayer(T entitypatch, E entityliving, R vanillaLayer, PoseStack poseStack, MultiBufferSource buffer, int packedLight, OpenMatrix4f[] poses, float bob, float yRot, float xRot, float partialTicks) {
        int i = Math.min((Integer)EpicFightMod.CLIENT_CONFIGS.maxStuckProjectiles.getValue(), this.numStuck(entityliving));
        RandomSource randomsource = RandomSource.m_216335_((long)entityliving.m_19879_());
        if (i > 0) {
            for (int j = 0; j < i; ++j) {
                poseStack.m_85836_();
                int randomJoint = Math.abs(randomsource.m_188502_()) % ((LivingEntityPatch)entitypatch).getArmature().getJointNumber();
                OpenMatrix4f modelMatrix = new OpenMatrix4f().mulFront(poses[randomJoint]);
                OpenMatrix4f transpose = OpenMatrix4f.transpose(modelMatrix, null);
                MathUtils.translateStack(poseStack, modelMatrix);
                MathUtils.rotateStack(poseStack, transpose);
                Vec3f vec = ((LivingEntityPatch)entitypatch).getArmature().searchJointById(randomJoint).getLocalTrasnform().toTranslationVector();
                float f = randomsource.m_188501_();
                float f1 = randomsource.m_188501_();
                float f2 = randomsource.m_188501_();
                float f3 = Mth.m_14179_((float)f, (float)(-vec.x * 0.5f), (float)(vec.x * 0.5f));
                float f4 = Mth.m_14179_((float)f1, (float)(-vec.y * 0.5f), (float)(vec.y * 0.5f));
                float f5 = Mth.m_14179_((float)f2, (float)(-vec.z * 0.5f), (float)(vec.z * 0.5f));
                poseStack.m_252880_(f3, f4, f5);
                f = -1.0f * (f * 2.0f - 1.0f);
                f1 = -1.0f * (f1 * 2.0f - 1.0f);
                f2 = -1.0f * (f2 * 2.0f - 1.0f);
                this.renderStuckItem(poseStack, buffer, packedLight, (Entity)entityliving, f, f1, f2, partialTicks);
                poseStack.m_85849_();
            }
        }
    }

    protected abstract int numStuck(E var1);

    protected abstract void renderStuckItem(PoseStack var1, MultiBufferSource var2, int var3, Entity var4, float var5, float var6, float var7, float var8);
}

