/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.item;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class RenderItemBase {
    protected final OpenMatrix4f mainhandcorrectionMatrix;
    protected final OpenMatrix4f offhandCorrectionMatrix;
    protected static final OpenMatrix4f BACK_COORECTION = new OpenMatrix4f().translate(0.5f, 0.85f, 0.15f).rotateDeg(125.0f, Vec3f.Z_AXIS).rotateDeg(100.0f, Vec3f.Y_AXIS);
    public static RenderEngine renderEngine;

    public RenderItemBase() {
        this(new OpenMatrix4f().translate(0.0f, 0.0f, -0.13f).rotateDeg(-90.0f, Vec3f.X_AXIS), new OpenMatrix4f().translate(0.0f, 0.0f, -0.13f).rotateDeg(-90.0f, Vec3f.X_AXIS));
    }

    public RenderItemBase(OpenMatrix4f mainhandcorrectionMatrix, OpenMatrix4f offhandCorrectionMatrix) {
        this.mainhandcorrectionMatrix = mainhandcorrectionMatrix;
        this.offhandCorrectionMatrix = offhandCorrectionMatrix;
    }

    public void renderItemInHand(ItemStack stack, LivingEntityPatch<?> entitypatch, InteractionHand hand, HumanoidArmature armature, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        OpenMatrix4f modelMatrix = this.getCorrectionMatrix(stack, entitypatch, hand);
        boolean isInMainhand = hand == InteractionHand.MAIN_HAND;
        Joint holdingHand = isInMainhand ? armature.toolR : armature.toolL;
        modelMatrix.mulFront(poses[holdingHand.getId()]);
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, modelMatrix);
        ItemDisplayContext transformType = isInMainhand ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91063_.f_109055_.m_269530_((LivingEntity)entitypatch.getOriginal(), stack, transformType, !isInMainhand, poseStack, buffer, packedLight);
        poseStack.m_85849_();
    }

    public void renderUnusableItemMount(ItemStack stack, LivingEntityPatch<?> entitypatch, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        OpenMatrix4f modelMatrix = new OpenMatrix4f(BACK_COORECTION);
        modelMatrix.mulFront(poses[entitypatch.getArmature().getRootJoint().getId()]);
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, modelMatrix);
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, packedLight, OverlayTexture.f_118083_, poseStack, buffer, null, 0);
        poseStack.m_85849_();
    }

    protected void mulPoseStack(PoseStack poseStack, OpenMatrix4f pose) {
        OpenMatrix4f transposed = pose.transpose(null);
        MathUtils.translateStack(poseStack, pose);
        MathUtils.rotateStack(poseStack, transposed);
        MathUtils.scaleStack(poseStack, transposed);
    }

    public OpenMatrix4f getCorrectionMatrix(ItemStack stack, LivingEntityPatch<?> itemHolder, InteractionHand hand) {
        return new OpenMatrix4f(hand == InteractionHand.MAIN_HAND ? this.mainhandcorrectionMatrix : this.offhandCorrectionMatrix);
    }
}

