/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.forgeevent.PrepareModelEvent;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.MeshProvider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.LayerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.LayerUtil;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.mixin.MixinLivingEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class PresetRenderer
extends PatchedEntityRenderer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityRenderer<LivingEntity>, AnimatedMesh>
implements LayerRenderer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityModel<LivingEntity>> {
    private final LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> presetRenderer;
    protected final Map<Class<?>, PatchedLayer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityModel<LivingEntity>, ? extends RenderLayer<LivingEntity, EntityModel<LivingEntity>>>> patchedLayers = Maps.newHashMap();
    protected final List<PatchedLayer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityModel<LivingEntity>, ? extends RenderLayer<LivingEntity, EntityModel<LivingEntity>>>> customLayers = Lists.newArrayList();
    protected final MeshProvider<AnimatedMesh> mesh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PresetRenderer(EntityRendererProvider.Context context, EntityType<?> entityType, LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer, MeshProvider<AnimatedMesh> mesh) {
        this.presetRenderer = renderer;
        this.mesh = mesh;
        ResourceLocation type = EntityType.m_20613_(entityType);
        FileToIdConverter filetoidconverter = FileToIdConverter.m_246568_((String)("animated_layers/" + type.m_135815_()));
        ArrayList layers = Lists.newArrayList();
        for (Map.Entry entry : filetoidconverter.m_247457_(context.m_174026_()).entrySet()) {
            BufferedReader reader = null;
            try {
                reader = ((Resource)entry.getValue()).m_215508_();
                JsonElement jsonelement = (JsonElement)GsonHelper.m_13776_((Gson)new GsonBuilder().create(), (Reader)reader, JsonElement.class);
                layers.add(Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)jsonelement));
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                EpicFightMod.LOGGER.error("Failed to parse layer file {} for {}", entry.getKey(), (Object)type);
                jsonparseexception.printStackTrace();
            }
            finally {
                try {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
        LayerUtil.addLayer(this, entityType, layers);
    }

    @Override
    public void render(LivingEntity entity, LivingEntityPatch<LivingEntity> entitypatch, EntityRenderer<LivingEntity> renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        super.render(entity, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks);
        Minecraft mc = Minecraft.m_91087_();
        MixinLivingEntityRenderer livingEntityRendererAccessor = (MixinLivingEntityRenderer)this.presetRenderer;
        boolean isVisible = livingEntityRendererAccessor.invokeIsBodyVisible(entity);
        boolean isVisibleToPlayer = !isVisible && !entity.m_20177_((Player)mc.f_91074_);
        boolean isGlowing = mc.m_91314_((Entity)entity);
        RenderType renderType = livingEntityRendererAccessor.invokeGetRenderType(entity, isVisible, isVisibleToPlayer, isGlowing);
        Armature armature = entitypatch.getArmature();
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, entity, entitypatch, partialTicks);
        OpenMatrix4f[] poseMatrices = this.getPoseMatrices(entitypatch, armature, partialTicks, false);
        if (renderType != null) {
            this.prepareVanillaModel(entity, (EntityModel<LivingEntity>)this.presetRenderer.m_7200_(), this.presetRenderer, partialTicks);
            AnimatedMesh mesh = (AnimatedMesh)this.getMeshProvider(entitypatch).get();
            this.prepareModel(mesh, entity, entitypatch, this.presetRenderer);
            PrepareModelEvent prepareModelEvent = new PrepareModelEvent(this, mesh, entitypatch, buffer, poseStack, packedLight, partialTicks);
            if (!MinecraftForge.EVENT_BUS.post((Event)prepareModelEvent)) {
                mesh.draw(poseStack, buffer, renderType, packedLight, 1.0f, 1.0f, 1.0f, isVisibleToPlayer ? 0.15f : 1.0f, this.getOverlayCoord(entity, entitypatch, partialTicks), armature, poseMatrices);
            }
        }
        if (!entity.m_5833_()) {
            this.renderLayer(this.presetRenderer, entitypatch, entity, poseMatrices, buffer, poseStack, packedLight, partialTicks);
        }
        if (renderType != null && Minecraft.m_91087_().m_91290_().m_114377_()) {
            for (Layer layer : entitypatch.getClientAnimator().getAllLayers()) {
                AnimationPlayer animPlayer = layer.animationPlayer;
                float playTime = animPlayer.getPrevElapsedTime() + (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()) * partialTicks;
                animPlayer.getAnimation().renderDebugging(poseStack, buffer, entitypatch, playTime, partialTicks);
            }
        }
        poseStack.m_85849_();
    }

    public float getVanillaRendererBob(LivingEntity entity, LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer, float partialTicks) {
        return (float)entity.f_19797_ + partialTicks;
    }

    protected void prepareVanillaModel(LivingEntity entityIn, EntityModel<LivingEntity> model, LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer, float partialTicks) {
        Entity entity;
        boolean shouldSit;
        model.f_102609_ = shouldSit = entityIn.m_20159_() && entityIn.m_20202_() != null && entityIn.m_20202_().shouldRiderSit();
        model.f_102610_ = entityIn.m_6162_();
        float f = Mth.m_14189_((float)partialTicks, (float)entityIn.f_20884_, (float)entityIn.f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)entityIn.f_20886_, (float)entityIn.f_20885_);
        float f2 = f1 - f;
        if (shouldSit && (entity = entityIn.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_((float)partialTicks, (float)entityIn.f_19860_, (float)entityIn.m_146909_());
        if (LivingEntityRenderer.m_194453_((LivingEntity)entityIn)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        float f7 = this.getVanillaRendererBob(entityIn, renderer, partialTicks);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.m_6084_()) {
            f8 = entityIn.f_267362_.m_267711_(partialTicks);
            f5 = entityIn.f_267362_.m_267756_() - entityIn.f_267362_.m_267731_() * (1.0f - partialTicks);
            if (entityIn.m_6162_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        model.m_6839_((Entity)entityIn, f5, f8, partialTicks);
        model.m_6973_((Entity)entityIn, f5, f8, f7, f2, f6);
    }

    protected void prepareModel(AnimatedMesh mesh, LivingEntity entity, LivingEntityPatch<LivingEntity> entitypatch, LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer) {
        mesh.initialize();
    }

    protected void renderLayer(LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer, LivingEntityPatch<LivingEntity> entitypatch, LivingEntity entity, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        float f = MathUtils.lerpBetween(entity.f_20884_, entity.f_20883_, partialTicks);
        float f1 = MathUtils.lerpBetween(entity.f_20886_, entity.f_20885_, partialTicks);
        float f2 = f1 - f;
        float f7 = entity.m_5686_(partialTicks);
        float bob = this.getVanillaRendererBob(entity, renderer, partialTicks);
        for (RenderLayer renderLayer : renderer.f_115291_) {
            Class<?> layerClass = renderLayer.getClass();
            if (layerClass.isAnonymousClass()) {
                layerClass = layerClass.getSuperclass();
            }
            if (!this.patchedLayers.containsKey(layerClass)) continue;
            this.patchedLayers.get(layerClass).renderLayer((LivingEntityPatch<LivingEntity>)entity, (LivingEntity)entitypatch, (RenderLayer<LivingEntity, EntityModel<LivingEntity>>)renderLayer, poseStack, buffer, packedLight, poses, bob, f2, f7, partialTicks);
        }
        for (PatchedLayer patchedLayer : this.customLayers) {
            patchedLayer.renderLayer(entity, entitypatch, null, poseStack, buffer, packedLight, poses, bob, f2, f7, partialTicks);
        }
    }

    protected int getOverlayCoord(LivingEntity entity, LivingEntityPatch<LivingEntity> entitypatch, float partialTicks) {
        return OverlayTexture.m_118093_((int)0, (int)OverlayTexture.m_118096_((entity.f_20916_ > 5 ? 1 : 0) != 0));
    }

    @Override
    public void addPatchedLayer(Class<?> originalLayerClass, PatchedLayer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityModel<LivingEntity>, ? extends RenderLayer<LivingEntity, EntityModel<LivingEntity>>> patchedLayer) {
        this.patchedLayers.putIfAbsent(originalLayerClass, patchedLayer);
    }

    @Override
    public void addCustomLayer(PatchedLayer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityModel<LivingEntity>, ? extends RenderLayer<LivingEntity, EntityModel<LivingEntity>>> patchedLayer) {
        this.customLayers.add(patchedLayer);
    }

    @Override
    public MeshProvider<AnimatedMesh> getDefaultMesh() {
        return this.mesh;
    }
}

