/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.particle.EpicFightParticles;

@OnlyIn(value=Dist.CLIENT)
public class DustParticle
extends TextureSheetParticle {
    private final PhysicsType physicsType;

    public DustParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, PhysicsType physicsType) {
        super(level, x, y, z);
        float angle;
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_107663_ = physicsType == PhysicsType.NORMAL ? this.f_107223_.m_188501_() * 0.01f + 0.01f : this.f_107223_.m_188501_() * 0.02f + 0.02f;
        this.f_107225_ = (physicsType == PhysicsType.NORMAL ? 12 : 2) + this.f_107223_.m_188503_(6);
        this.f_107219_ = physicsType == PhysicsType.NORMAL;
        this.f_107226_ = physicsType == PhysicsType.NORMAL ? 0.68f : 0.0f;
        this.f_107231_ = angle = this.f_107223_.m_188501_() * 360.0f;
        this.f_107204_ = angle;
        Vec3 deltaMovement = physicsType.function.getDeltaMovement(xd, yd, zd);
        this.f_107215_ = deltaMovement.f_82479_;
        this.f_107216_ = deltaMovement.f_82480_;
        this.f_107217_ = deltaMovement.f_82481_;
        this.physicsType = physicsType;
    }

    public ParticleRenderType m_7556_() {
        return EpicFightParticleRenderTypes.BLEND_LIGHTMAP_PARTICLE;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.physicsType == PhysicsType.EXPANSIVE) {
            this.f_107215_ *= 0.48;
            this.f_107216_ *= 0.48;
            this.f_107217_ *= 0.48;
        } else if (this.physicsType == PhysicsType.CONTRACTIVE) {
            this.f_107215_ *= 1.35;
            this.f_107216_ *= 1.35;
            this.f_107217_ *= 1.35;
        }
    }

    private static enum PhysicsType {
        EXPANSIVE((dx, dy, dz) -> new Vec3(dx, dy, dz)),
        CONTRACTIVE((dx, dy, dz) -> new Vec3(dx * 0.02, dy * 0.02, dz * 0.02)),
        NORMAL((dx, dy, dz) -> new Vec3(dx, dy, dz));

        DeltaMovementFunction function;

        private PhysicsType(DeltaMovementFunction function) {
            this.function = function;
        }
    }

    @FunctionalInterface
    static interface DeltaMovementFunction {
        public Vec3 getDeltaMovement(double var1, double var3, double var5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NormalDustProvider
    implements ParticleProvider<SimpleParticleType> {
        protected SpriteSet sprite;

        public NormalDustProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DustParticle dustParticle = new DustParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, PhysicsType.NORMAL);
            dustParticle.m_108335_(this.sprite);
            return dustParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ContractiveDustProvider
    implements ParticleProvider<SimpleParticleType> {
        protected SpriteSet sprite;

        public ContractiveDustProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DustParticle dustParticle = new DustParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, PhysicsType.CONTRACTIVE);
            dustParticle.m_108335_(this.sprite);
            return dustParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ExpansiveDustProvider
    implements ParticleProvider<SimpleParticleType> {
        protected SpriteSet sprite;

        public ExpansiveDustProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DustParticle dustParticle = new DustParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, PhysicsType.EXPANSIVE);
            dustParticle.m_108335_(this.sprite);
            return dustParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ContractiveMetaParticle
    extends NoRenderParticle {
        private final double radius;
        private final int density;

        public ContractiveMetaParticle(ClientLevel level, double x, double y, double z, double radius, int lifetime, int density) {
            super(level, x, y, z);
            this.radius = radius;
            this.f_107225_ = lifetime;
            this.density = density;
        }

        public void m_5989_() {
            super.m_5989_();
            for (int x = -1; x <= 1; x += 2) {
                for (int y = -1; y <= 1; y += 2) {
                    for (int z = -1; z <= 1; z += 2) {
                        for (int i = 0; i < this.density; ++i) {
                            Vec3 rand = new Vec3(Math.random() * (double)x, Math.random() * (double)y, Math.random() * (double)z).m_82541_().m_82490_(this.radius);
                            this.f_107208_.m_7106_((ParticleOptions)EpicFightParticles.DUST_CONTRACTIVE.get(), this.f_107212_ + rand.f_82479_, this.f_107213_ + rand.f_82480_, this.f_107214_ + rand.f_82481_, -rand.f_82479_, -rand.f_82480_, -rand.f_82481_);
                        }
                    }
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public static class Provider
        implements ParticleProvider<SimpleParticleType> {
            public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
                ContractiveMetaParticle particle = new ContractiveMetaParticle(worldIn, x, y, z, xSpeed, (int)Double.doubleToLongBits(ySpeed), (int)Double.doubleToLongBits(zSpeed));
                return particle;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ExpansiveMetaParticle
    extends NoRenderParticle {
        public ExpansiveMetaParticle(ClientLevel level, double x, double y, double z, double radius, int density) {
            super(level, x, y, z);
            for (int vx = -1; vx <= 1; vx += 2) {
                for (int vz = -1; vz <= 1; vz += 2) {
                    for (int i = 0; i < density; ++i) {
                        Vec3 rand = new Vec3(Math.random() * (double)vx, Math.random(), Math.random() * (double)vz).m_82541_().m_82490_(radius);
                        level.m_7106_((ParticleOptions)EpicFightParticles.DUST_EXPANSIVE.get(), x, y, z, rand.f_82479_, rand.f_82480_, rand.f_82481_);
                    }
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public static class Provider
        implements ParticleProvider<SimpleParticleType> {
            public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
                ExpansiveMetaParticle particle = new ExpansiveMetaParticle(worldIn, x, y, z, xSpeed, (int)Double.doubleToLongBits(ySpeed));
                return particle;
            }
        }
    }
}

