/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.client.gui.screen.config.EditSwitchingItemScreen;

@OnlyIn(value=Dist.CLIENT)
public class EditItemListScreen
extends Screen {
    private final Screen parentScreen;
    private final EditSwitchingItemScreen.RegisteredItemList targetList;
    private final EditSwitchingItemScreen.RegisteredItemList opponentList;
    private final List<Item> registered;
    private final List<Item> opponentRegistered;
    private ItemList allItemsList;
    private ItemList selectedItemList;
    private final EditBox searchBox;

    protected EditItemListScreen(Screen parentScreen, EditSwitchingItemScreen.RegisteredItemList targetList, EditSwitchingItemScreen.RegisteredItemList opponentList) {
        super((Component)Component.m_237119_());
        this.parentScreen = parentScreen;
        this.targetList = targetList;
        this.opponentList = opponentList;
        this.registered = targetList.toList();
        this.opponentRegistered = opponentList.toList();
        this.allItemsList = new ItemList(this.f_96541_, 0, 0, 0, 0, Lists.newArrayList((Iterable)ForgeRegistries.ITEMS.getValues()), Type.SELECTABLES);
        this.selectedItemList = new ItemList(this.f_96541_, 0, 0, 0, 0, Lists.newArrayList(), Type.SELECTED);
        this.searchBox = new EditBox(parentScreen.getMinecraft().f_91062_, 0, 0, 150, 16, (Component)Component.m_237113_((String)"datapack_edit.keyword"));
        this.searchBox.m_94151_(this.allItemsList::refreshItems);
    }

    protected void m_7856_() {
        this.allItemsList.m_93437_(this.f_96543_ - 50, this.f_96544_, 36, this.f_96544_ - 120);
        this.selectedItemList.m_93437_(this.f_96543_ - 50, this.f_96544_, this.f_96544_ - 100, this.f_96544_ - 30);
        this.allItemsList.m_93507_(25);
        this.selectedItemList.m_93507_(25);
        this.searchBox.m_264152_(this.f_96543_ - 176, 16);
        this.m_142416_((GuiEventListener)this.allItemsList);
        this.m_142416_((GuiEventListener)this.selectedItemList);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            for (Item item : this.selectedItemList.toList()) {
                this.targetList.addEntry(item);
                this.opponentList.removeIfPresent(item);
            }
            this.m_7379_();
        }).m_252987_(this.f_96543_ - 85, this.f_96544_ - 26, 60, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(guiGraphics);
        this.allItemsList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.selectedItemList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"Item List").m_130940_(ChatFormatting.UNDERLINE), 28, 18, 0xFFFFFF, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"Seleted Items").m_130940_(ChatFormatting.UNDERLINE), 28, this.f_96544_ - 114, 0xFFFFFF, false);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    @OnlyIn(value=Dist.CLIENT)
    class ItemList
    extends ObjectSelectionList<ButtonEntry> {
        private final Type type;
        private int itemsInColumn;
        private List<Item> items;

        public ItemList(Minecraft minecraft, int width, int height, int top, int bottom, List<Item> items, Type type) {
            super(minecraft, width, height, top, bottom, 18);
            this.itemsInColumn = width / 17;
            this.type = type;
            this.items = items;
            for (Item item : this.items) {
                if (this.type == Type.SELECTABLES && EditItemListScreen.this.registered.contains(item)) continue;
                this.addItem(item);
            }
            this.m_93488_(false);
            this.m_93473_(false, 0);
            this.m_93496_(false);
        }

        public boolean has(Item item) {
            for (ButtonEntry entry : this.m_6702_()) {
                for (ItemButton button : entry.buttonList) {
                    if (!button.itemStack.m_41720_().equals(item)) continue;
                    return true;
                }
            }
            return false;
        }

        public void addItem(Item item) {
            if (this.m_6702_().size() == 0) {
                this.m_7085_((AbstractSelectionList.Entry)new ButtonEntry());
            }
            ButtonEntry entry = (ButtonEntry)this.m_93500_(this.m_6702_().size() - 1);
            if (entry.buttonList.size() > this.itemsInColumn) {
                this.m_7085_((AbstractSelectionList.Entry)new ButtonEntry());
                entry = (ButtonEntry)this.m_93500_(this.m_6702_().size() - 1);
            }
            IPressableExtended pressAction = null;
            if (this.type == Type.SELECTABLES) {
                pressAction = (screen, button, x, y) -> {
                    if (!screen.selectedItemList.has(item)) {
                        screen.selectedItemList.addItem(button.itemStack.m_41720_());
                    }
                };
            } else if (this.type == Type.SELECTED) {
                pressAction = (screen, button, x, y) -> screen.selectedItemList.removeAndRearrange(x, y);
            }
            entry.buttonList.add(new ItemButton(0, 0, 16, 16, pressAction, EditItemListScreen.this, item.m_7968_()));
        }

        public void removeAndRearrange(int x, int y) {
            ((ButtonEntry)this.m_93500_((int)y)).buttonList.remove(x);
        }

        private void refreshItems(String keyword) {
            this.m_6702_().clear();
            this.items.stream().filter(item -> item.m_5524_().contains(keyword)).forEach(this::addItem);
            this.m_93410_(0.0);
        }

        public List<Item> toList() {
            ArrayList result = Lists.newArrayList();
            for (ButtonEntry entry : this.m_6702_()) {
                for (ItemButton button : entry.buttonList) {
                    result.add(button.itemStack.m_41720_());
                }
            }
            return result;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            ButtonEntry listener = this.getEntry(mouseX, mouseY);
            if (listener != null) {
                return listener.m_6375_(mouseX, mouseY, button);
            }
            return false;
        }

        public ButtonEntry getEntry(double mouseX, double mouseY) {
            if (mouseX < (double)(this.f_93393_ + 2) || mouseX > (double)(this.f_93392_ - 8) || mouseY < (double)(this.f_93390_ + 2) || mouseY > (double)(this.f_93391_ - 2)) {
                return null;
            }
            int column = (int)((this.m_93517_() + mouseY - (double)this.f_93390_ - 4.0) / (double)this.f_93387_);
            if (this.m_6702_().size() > column) {
                return (ButtonEntry)this.m_93500_(column);
            }
            return null;
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            this.m_7733_(guiGraphics);
            int i = this.m_5756_();
            int j = i + 6;
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Screen.f_279548_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_7421_((float)this.f_93393_ / 32.0f, (float)(this.f_93391_ + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_7421_((float)this.f_93392_ / 32.0f, (float)(this.f_93391_ + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_7421_((float)this.f_93392_ / 32.0f, (float)(this.f_93390_ + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_7421_((float)this.f_93393_ / 32.0f, (float)(this.f_93390_ + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            tessellator.m_85914_();
            int j1 = this.m_5747_();
            int k = this.f_93390_ + 4 - (int)this.m_93517_();
            this.m_7415_(guiGraphics, j1, k);
            this.m_239227_(guiGraphics, mouseX, mouseY, partialTicks);
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Screen.f_279548_);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)519);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, -100.0).m_7421_(0.0f, (float)this.f_93390_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93390_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93390_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93390_ - 16.0, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)(this.f_93390_ - 16) / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_ - 16.0, -100.0).m_7421_(0.0f, (float)(this.f_93390_ - 16) / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93389_, -100.0).m_7421_(0.0f, (float)this.f_93389_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93389_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93389_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93391_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93391_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, -100.0).m_7421_(0.0f, (float)this.f_93391_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            tessellator.m_85914_();
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShader(GameRenderer::m_172811_);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_5483_((double)this.f_93393_, (double)(this.f_93390_ + 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)(this.f_93390_ + 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)(this.f_93391_ - 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)(this.f_93391_ - 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            tessellator.m_85914_();
            int k1 = this.m_93518_();
            if (k1 > 0) {
                RenderSystem.setShader(GameRenderer::m_172811_);
                int l1 = (int)((float)((this.f_93391_ - this.f_93390_) * (this.f_93391_ - this.f_93390_)) / (float)this.m_5775_());
                l1 = Mth.m_14045_((int)l1, (int)32, (int)(this.f_93391_ - this.f_93390_ - 8));
                int i2 = (int)this.m_93517_() * (this.f_93391_ - this.f_93390_ - l1) / k1 + this.f_93390_;
                if (i2 < this.f_93390_) {
                    i2 = this.f_93390_;
                }
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferbuilder.m_5483_((double)i, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)(i2 + l1), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)(i2 + l1), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)i2, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)i2, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)(i2 + l1 - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
                bufferbuilder.m_5483_((double)(j - 1), (double)(i2 + l1 - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
                bufferbuilder.m_5483_((double)(j - 1), (double)i2, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)i2, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
                tessellator.m_85914_();
            }
            this.m_7154_(guiGraphics, mouseX, mouseY);
            RenderSystem.disableBlend();
        }

        public int m_5747_() {
            return this.f_93393_ + 2;
        }

        protected int m_5756_() {
            return this.f_93392_ - 6;
        }

        public void m_93437_(int width, int height, int top, int bottom) {
            super.m_93437_(width, height, top, bottom);
            this.itemsInColumn = width / 17;
            this.refreshItems(EditItemListScreen.this.searchBox.m_94155_());
        }

        @OnlyIn(value=Dist.CLIENT)
        class ButtonEntry
        extends ObjectSelectionList.Entry<ButtonEntry> {
            final List<ItemButton> buttonList = Lists.newArrayList();

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                int x = 0;
                for (ItemButton button : this.buttonList) {
                    button.m_252865_(left + x);
                    button.m_253211_(top);
                    button.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                    x += 16;
                }
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    int row = (int)((mouseX - (double)ItemList.this.f_93393_ - 2.0) / 16.0);
                    int column = (int)((ItemList.this.m_93517_() + mouseY - (double)ItemList.this.f_93390_ - 4.0) / (double)ItemList.this.f_93387_);
                    ItemButton itembutton = this.getButton(row);
                    if (itembutton != null) {
                        ItemButton itemButton = itembutton = itembutton.m_5953_(mouseX, mouseY) ? itembutton : null;
                        if (itembutton != null) {
                            itembutton.pressedAction.onPress(EditItemListScreen.this, itembutton, row, column);
                            itembutton.m_7435_(Minecraft.m_91087_().m_91106_());
                        }
                    }
                }
                return false;
            }

            public ItemButton getButton(int index) {
                return this.buttonList.size() > index ? this.buttonList.get(index) : null;
            }

            public Component m_142172_() {
                return Component.m_237119_();
            }
        }
    }

    private static enum Type {
        SELECTABLES,
        SELECTED;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressableExtended {
        public void onPress(EditItemListScreen var1, ItemButton var2, int var3, int var4);
    }

    @OnlyIn(value=Dist.CLIENT)
    class ItemButton
    extends Button {
        private static final Set<Item> UNRENDERABLES = Sets.newHashSet();
        private final ItemStack itemStack;
        private final IPressableExtended pressedAction;

        public ItemButton(int x, int y, int width, int height, IPressableExtended pressedAction, EditItemListScreen screen, ItemStack itemStack) {
            super(x, y, width, height, (Component)Component.m_237119_(), button -> {}, Button.f_252438_);
            this.itemStack = itemStack;
            this.pressedAction = pressedAction;
        }

        public Tooltip m_278622_() {
            Component displayName = this.itemStack.m_41786_();
            Object tooltipMessage = null;
            tooltipMessage = EditItemListScreen.this.opponentRegistered.contains(this.itemStack.m_41720_()) ? Component.m_237110_((String)"epicfight.gui.warn_already_registered", (Object[])new Object[]{displayName.equals(Component.m_237119_()) ? Component.m_237113_((String)ForgeRegistries.ITEMS.getKey((Object)this.itemStack.m_41720_()).toString()) : displayName}) : (displayName.equals(Component.m_237119_()) ? Component.m_237113_((String)ForgeRegistries.ITEMS.getKey((Object)this.itemStack.m_41720_()).toString()) : displayName);
            return Tooltip.m_257550_((Component)tooltipMessage);
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.m_5953_(mouseX, mouseY)) {
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tessellator.m_85915_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferbuilder.m_5483_((double)this.m_252754_(), (double)this.m_252907_() + (double)this.f_93619_, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_5483_((double)this.m_252754_() + (double)this.f_93618_, (double)this.m_252907_() + (double)this.f_93619_, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_5483_((double)this.m_252754_() + (double)this.f_93618_, (double)this.m_252907_(), 0.0).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_5483_((double)this.m_252754_(), (double)this.m_252907_(), 0.0).m_6122_(255, 255, 255, 255).m_5752_();
                tessellator.m_85914_();
                Component displayName = this.itemStack.m_41786_();
                Object tooltipMessage = null;
                tooltipMessage = EditItemListScreen.this.opponentRegistered.contains(this.itemStack.m_41720_()) ? Component.m_237110_((String)"epicfight.gui.warn_already_registered", (Object[])new Object[]{displayName.equals(Component.m_237119_()) ? Component.m_237113_((String)ForgeRegistries.ITEMS.getKey((Object)this.itemStack.m_41720_()).toString()) : displayName}) : (displayName.equals(Component.m_237119_()) ? Component.m_237113_((String)ForgeRegistries.ITEMS.getKey((Object)this.itemStack.m_41720_()).toString()) : displayName);
                this.m_257544_(Tooltip.m_257550_((Component)tooltipMessage));
            } else {
                this.m_257544_(null);
            }
            try {
                try {
                    if (!UNRENDERABLES.contains(this.itemStack.m_41720_())) {
                        guiGraphics.m_280480_(this.itemStack, this.m_252754_(), this.m_252907_());
                    }
                }
                catch (Exception e) {
                    UNRENDERABLES.add(this.itemStack.m_41720_());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

