/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events;

import com.mojang.datafixers.util.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.data.reloader.ItemCapabilityReloadListener;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponTypeReloadListener;
import yesman.epicfight.world.capabilities.provider.EntityPatchProvider;
import yesman.epicfight.world.capabilities.provider.ItemCapabilityProvider;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.RightClickItemEvent;
import yesman.epicfight.world.level.block.FractureBlockState;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
public class ClientEvents {
    private static final Pair<ResourceLocation, ResourceLocation> OFFHAND_TEXTURE = Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
    private static final Minecraft minecraft = Minecraft.m_91087_();
    @Deprecated
    public static ClientboundRespawnPacket packet;

    @SubscribeEvent
    public static void mouseClickEvent(ScreenEvent.MouseButtonPressed.Pre event) {
        CapabilityItem cap;
        Slot slot;
        if (event.getScreen() instanceof AbstractContainerScreen && (slot = ((AbstractContainerScreen)event.getScreen()).getSlotUnderMouse()) != null && !(cap = EpicFightCapabilities.getItemStackCapability(ClientEvents.minecraft.f_91074_.f_36096_.m_142621_())).canBePlacedOffhand() && slot.m_7543_() != null && slot.m_7543_().equals(OFFHAND_TEXTURE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void mouseReleaseEvent(ScreenEvent.MouseButtonReleased.Pre event) {
        CapabilityItem cap;
        Slot slot;
        if (event.getScreen() instanceof AbstractContainerScreen && (slot = ((AbstractContainerScreen)event.getScreen()).getSlotUnderMouse()) != null && !(cap = EpicFightCapabilities.getItemStackCapability(ClientEvents.minecraft.f_91074_.f_36096_.m_142621_())).canBePlacedOffhand() && slot.m_7543_() != null && slot.m_7543_().equals(OFFHAND_TEXTURE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void presssKeyInGui(ScreenEvent.KeyPressed.Pre event) {
        Slot slot;
        CapabilityItem itemCapability = CapabilityItem.EMPTY;
        if (event.getKeyCode() == ClientEvents.minecraft.f_91066_.f_92093_.getKey().m_84873_()) {
            Slot slot2;
            if (event.getScreen() instanceof AbstractContainerScreen && (slot2 = ((AbstractContainerScreen)event.getScreen()).getSlotUnderMouse()) != null && slot2.m_6657_() && !(itemCapability = EpicFightCapabilities.getItemStackCapability(slot2.m_7993_())).canBePlacedOffhand()) {
                event.setCanceled(true);
            }
        } else if (event.getKeyCode() >= 49 && event.getKeyCode() <= 57 && event.getScreen() instanceof AbstractContainerScreen && (slot = ((AbstractContainerScreen)event.getScreen()).getSlotUnderMouse()) != null && slot.m_7543_() != null && slot.m_7543_().equals(OFFHAND_TEXTURE) && !(itemCapability = EpicFightCapabilities.getItemStackCapability(ClientEvents.minecraft.f_91074_.m_150109_().m_8020_(event.getKeyCode() - 49))).canBePlacedOffhand()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void rightClickItemClient(PlayerInteractEvent.RightClickItem event) {
        LocalPlayerPatch playerpatch;
        if (event.getSide() == LogicalSide.CLIENT && (playerpatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LocalPlayerPatch.class)) != null && ((LocalPlayer)playerpatch.getOriginal()).m_21206_().m_41780_() == UseAnim.NONE) {
            boolean canceled = playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, new RightClickItemEvent<LocalPlayerPatch>(playerpatch));
            if (playerpatch.getEntityState().movementLocked()) {
                canceled = true;
            }
            event.setCanceled(canceled);
        }
    }

    @SubscribeEvent
    public static void clientLoggingInEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        LocalPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch((Entity)event.getPlayer(), LocalPlayerPatch.class);
        if (playerpatch != null) {
            ClientEngine.getInstance().controllEngine.setPlayerPatch(playerpatch);
        }
        ClientEngine.getInstance().renderEngine.battleModeUI.reset();
        ClientEngine.getInstance().renderEngine.versionNotifier.reset();
    }

    @SubscribeEvent
    public static void clientRespawnEvent(ClientPlayerNetworkEvent.Clone event) {
        LocalPlayerPatch oldCap = EpicFightCapabilities.getEntityPatch((Entity)event.getOldPlayer(), LocalPlayerPatch.class);
        LocalPlayerPatch newCap = EpicFightCapabilities.getEntityPatch((Entity)event.getNewPlayer(), LocalPlayerPatch.class);
        if (oldCap != null && newCap != null) {
            if (packet != null && packet.m_263558_((byte)3)) {
                newCap.copySkillsFrom(oldCap);
            }
            packet = null;
            newCap.onRespawnLocalPlayer(event);
            newCap.toMode(oldCap.getPlayerMode(), false);
        }
        ClientEngine.getInstance().controllEngine.setPlayerPatch(newCap);
        ClientEngine.getInstance().renderEngine.battleModeUI.reset();
        ClientEngine.getInstance().renderEngine.versionNotifier.reset();
    }

    @SubscribeEvent
    public static void clientLogoutEvent(ClientPlayerNetworkEvent.LoggingOut event) {
        if (event.getPlayer() != null) {
            ItemCapabilityReloadListener.reset();
            ItemCapabilityProvider.clear();
            EntityPatchProvider.clear();
            WeaponTypeReloadListener.clear();
            ClientEngine.getInstance().renderEngine.zoomOut(0);
            ClientEngine.getInstance().renderEngine.battleModeUI.reset();
            ClientEngine.getInstance().renderEngine.resetRenderers();
        }
        FractureBlockState.reset();
    }
}

