/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.MeshPartDefinition;
import yesman.epicfight.api.client.model.ModelPart;
import yesman.epicfight.api.client.model.VertexBuilder;

@OnlyIn(value=Dist.CLIENT)
public abstract class Mesh<P extends ModelPart<V>, V extends VertexBuilder> {
    protected final float[] positions;
    protected final float[] normals;
    protected final float[] uvs;
    protected final int vertexCount;
    protected final RenderProperties renderProperties;
    protected final Map<String, P> parts;

    public Mesh(@Nullable Map<String, float[]> arrayMap, @Nullable Map<MeshPartDefinition, List<V>> partBuilders, @Nullable Mesh<P, V> parent, RenderProperties renderProperties) {
        this.positions = parent == null ? arrayMap.get("positions") : parent.positions;
        this.normals = parent == null ? arrayMap.get("normals") : parent.normals;
        this.uvs = parent == null ? arrayMap.get("uvs") : parent.uvs;
        this.renderProperties = renderProperties;
        this.parts = parent == null ? this.createModelPart(partBuilders) : parent.parts;
        int totalV = 0;
        for (ModelPart modelpart : this.parts.values()) {
            totalV += modelpart.getVertices().size();
        }
        this.vertexCount = totalV;
    }

    protected abstract Map<String, P> createModelPart(Map<MeshPartDefinition, List<V>> var1);

    protected abstract P getOrLogException(Map<String, P> var1, String var2);

    public abstract void draw(PoseStack var1, VertexConsumer var2, DrawingFunction var3, int var4, float var5, float var6, float var7, float var8, int var9);

    public boolean hasPart(String part) {
        return this.parts.containsKey(part);
    }

    public ModelPart<V> getPart(String part) {
        return (ModelPart)this.parts.get(part);
    }

    public Collection<P> getAllParts() {
        return this.parts.values();
    }

    public RenderProperties getRenderProperty() {
        return this.renderProperties;
    }

    public void initialize() {
        this.parts.values().forEach(part -> part.setHidden(false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RenderProperties {
        protected String customTexturePath;
        protected boolean isTransparent;
        protected Object2BooleanMap<String> parentPartVisualizer;

        public String getCustomTexturePath() {
            return this.customTexturePath;
        }

        public boolean isTransparent() {
            return this.isTransparent;
        }

        public Object2BooleanMap<String> getParentPartVisualizer() {
            return this.parentPartVisualizer;
        }

        public RenderProperties customTexturePath(String path) {
            this.customTexturePath = path;
            return this;
        }

        public RenderProperties transparency(boolean isTransparent) {
            this.isTransparent = isTransparent;
            return this;
        }

        public RenderProperties newPartVisualizer(String partName, boolean setVisible) {
            if (this.parentPartVisualizer == null) {
                this.parentPartVisualizer = new Object2BooleanOpenHashMap();
            }
            this.parentPartVisualizer.put((Object)partName, setVisible);
            return this;
        }

        public static RenderProperties create() {
            return new RenderProperties();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @FunctionalInterface
    public static interface DrawingFunction {
        public static final DrawingFunction ENTITY_TEXTURED = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> builder.m_5954_(posX, posY, posZ, r, g, b, a, u, v, overlay, packedLight, normX, normY, normZ);
        public static final DrawingFunction ENTITY_PARTICLE = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> {
            builder.m_5483_((double)posX, (double)posY, (double)posZ);
            builder.m_85950_(r, g, b, a);
            builder.m_85969_(packedLight);
            builder.m_5752_();
        };
        public static final DrawingFunction ENTITY_SOLID = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> {
            builder.m_5483_((double)posX, (double)posY, (double)posZ);
            builder.m_85950_(r, g, b, a);
            builder.m_5601_(normX, normY, normZ);
            builder.m_5752_();
        };
        public static final DrawingFunction ENTITY_NO_LIGHTING = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> {
            builder.m_5483_((double)posX, (double)posY, (double)posZ);
            builder.m_85950_(r, g, b, a);
            builder.m_7421_(u, v);
            builder.m_85969_(packedLight);
            builder.m_5752_();
        };

        public void draw(VertexConsumer var1, float var2, float var3, float var4, float var5, float var6, float var7, int var8, float var9, float var10, float var11, float var12, float var13, float var14, int var15);
    }
}

