/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3i;
import yesman.epicfight.api.client.model.VertexBuilder;

@OnlyIn(value=Dist.CLIENT)
public class AnimatedVertexBuilder
extends VertexBuilder {
    public final Vector3i joint;
    public final Vector3i weight;
    public final int count;

    public AnimatedVertexBuilder(int position, int uv, int normal, Vector3i joint, Vector3i weight, int count) {
        super(position, uv, normal);
        this.joint = joint;
        this.weight = weight;
        this.count = count;
    }

    public int getJointId(int index) {
        switch (index) {
            case 0: {
                return this.joint.x;
            }
            case 1: {
                return this.joint.y;
            }
            case 2: {
                return this.joint.z;
            }
        }
        return -1;
    }

    public int getWeightIndex(int index) {
        switch (index) {
            case 0: {
                return this.weight.x;
            }
            case 1: {
                return this.weight.y;
            }
            case 2: {
                return this.weight.z;
            }
        }
        return -1;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AnimatedVertexBuilder) {
            AnimatedVertexBuilder vb = (AnimatedVertexBuilder)o;
            return this.position == vb.position && this.uv == vb.uv && this.normal == vb.normal && this.count == vb.count && this.joint.x == vb.joint.x && this.joint.y == vb.joint.y && this.joint.z == vb.joint.z && this.weight.x == vb.weight.x && this.weight.y == vb.weight.y && this.weight.z == vb.weight.z;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.position;
        result = 31 * result + this.uv;
        result = 31 * result + this.normal;
        result = 31 * result + this.count;
        result = 31 * result + this.joint.x;
        result = 31 * result + this.joint.y;
        result = 31 * result + this.joint.z;
        result = 31 * result + this.weight.x;
        result = 31 * result + this.weight.y;
        result = 31 * result + this.weight.z;
        return result;
    }
}

