/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.grappling;

import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

public class GrapplingTryAnimation
extends AttackAnimation {
    private final AnimationProvider<?> grapplingAttackAnimation;
    private final AnimationProvider<?> failAnimation;
    private final AnimationProvider<?> grapplingHitAnimation;

    public GrapplingTryAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, Collider collider, Joint colliderJoint, String path, AnimationProvider<?> grapplingHitAnimation, AnimationProvider<?> interactAnimation, AnimationProvider<?> failAnimation, Armature armature) {
        this(convertTime, antic, preDelay, contact, recovery, InteractionHand.MAIN_HAND, collider, colliderJoint, path, grapplingHitAnimation, interactAnimation, failAnimation, armature);
    }

    public GrapplingTryAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, Collider collider, Joint colliderJoint, String path, AnimationProvider<?> grapplingHitAnimation, AnimationProvider<?> interactAnimation, AnimationProvider<?> failAnimation, Armature armature) {
        super(convertTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, path, armature);
        this.grapplingAttackAnimation = interactAnimation;
        this.failAnimation = failAnimation;
        this.grapplingHitAnimation = grapplingHitAnimation;
        this.addProperty(AnimationProperty.AttackAnimationProperty.ATTACK_SPEED_FACTOR, Float.valueOf(0.0f));
        this.addProperty(AnimationProperty.ActionAnimationProperty.MOVE_ON_LINK, Boolean.valueOf(false));
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.TRACE_DEST_LOCATION_BEGIN);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, MoveCoordFunctions.TRACE_DEST_LOCATION);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_GET, MoveCoordFunctions.WORLD_COORD);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        LivingEntityPatch hitEntityPatch;
        LivingEntity hitEntity;
        super.begin(entitypatch);
        if (!entitypatch.isLogicalClient() && (hitEntity = entitypatch.getTarget()) != null && (hitEntityPatch = EpicFightCapabilities.getEntityPatch((Entity)hitEntity, LivingEntityPatch.class)) != null) {
            hitEntityPatch.notifyGrapplingWarning();
        }
    }

    @Override
    public void end(LivingEntityPatch<?> entitypatch, DynamicAnimation nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        if (isEnd && !entitypatch.isLogicalClient()) {
            float poseTime;
            AnimationPlayer player;
            float prevPoseTime;
            AttackAnimation.Phase phase;
            List<Entity> list;
            LivingEntity hitEntity = entitypatch.getTarget();
            if (hitEntity != null && (list = (phase = this.getPhaseByTime(0.0f)).getCollidingEntities(entitypatch, this, prevPoseTime = (player = ((Animator)entitypatch.getAnimator()).getPlayerFor(this)).getPrevElapsedTime(), poseTime = player.getElapsedTime(), this.getPlaySpeed(entitypatch, this))).contains(hitEntity)) {
                EpicFightDamageSource dmgSource = this.getEpicFightDamageSource(entitypatch, (Entity)hitEntity, phase);
                if (entitypatch.tryHurt((DamageSource)dmgSource, (float)0.0f).resultType.dealtDamage()) {
                    entitypatch.reserveAnimation((StaticAnimation)this.grapplingAttackAnimation.get());
                    entitypatch.setGrapplingTarget(hitEntity);
                    LivingEntityPatch hitEntityPatch = EpicFightCapabilities.getEntityPatch((Entity)hitEntity, LivingEntityPatch.class);
                    if (hitEntityPatch != null) {
                        hitEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, ((LivingEntity)entitypatch.getOriginal()).m_20182_());
                        hitEntityPatch.playAnimationSynchronized((StaticAnimation)this.grapplingHitAnimation.get(), 0.0f);
                    }
                    return;
                }
            }
            entitypatch.reserveAnimation((StaticAnimation)this.failAnimation.get());
        }
    }

    @Override
    protected void attackTick(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
    }
}

