/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.datapack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationClip;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.animation.types.datapack.ClipHoldingAnimation;
import yesman.epicfight.api.animation.types.datapack.FakeAnimation;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.JointMask;
import yesman.epicfight.api.client.animation.property.JointMaskReloadListener;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class FakeStaticAnimation
extends StaticAnimation
implements ClipHoldingAnimation {
    protected AnimationClip clip;
    protected FakeAnimation fakeAnimation;

    public FakeStaticAnimation(float convertTime, boolean isRepeat, String path, Armature armature) {
        super(convertTime, isRepeat, path, armature, true);
    }

    @Override
    public void setCreator(FakeAnimation fakeAnimation) {
        this.fakeAnimation = fakeAnimation;
    }

    @Override
    public FakeAnimation getCreator() {
        return this.fakeAnimation;
    }

    @Override
    public void setAnimationClip(AnimationClip clip) {
        this.clip = clip;
    }

    @Override
    public AnimationClip getAnimationClip() {
        return this.clip;
    }

    @Override
    public void putOnPlayer(AnimationPlayer animationPlayer, LivingEntityPatch<?> entitypatch) {
        animationPlayer.setPlayAnimation(this);
        animationPlayer.tick(entitypatch);
    }

    @Override
    public FakeAnimation buildAnimation(JsonArray rawAnimationJson) {
        FakeAnimation fakeAnimation = new FakeAnimation(this.registryName.toString(), this.armature, this.clip, rawAnimationJson);
        fakeAnimation.setAnimationClass(FakeAnimation.AnimationType.STATIC);
        fakeAnimation.setParameter("convertTime", Float.valueOf(this.convertTime));
        fakeAnimation.setParameter("isRepeat", this.isRepeat());
        fakeAnimation.setParameter("path", this.registryName.toString());
        fakeAnimation.setParameter("armature", this.armature);
        JsonObject propertiesJson = fakeAnimation.getPropertiesJson();
        this.getProperty(ClientAnimationProperties.MULTILAYER_ANIMATION).ifPresentOrElse(multilayer -> {
            JsonObject multilayerJson = new JsonObject();
            JsonObject baseJson = new JsonObject();
            baseJson.addProperty("priority", multilayer.getPriority().toString());
            JsonArray baseMasks = new JsonArray();
            this.getProperty(ClientAnimationProperties.JOINT_MASK).ifPresent(jointMaskEntry -> {
                for (Map.Entry<LivingMotion, JointMask.JointMaskSet> entry : jointMaskEntry.getEntries()) {
                    JsonObject maskObj = new JsonObject();
                    maskObj.addProperty("livingmotion", entry.getKey().toString());
                    maskObj.addProperty("type", JointMaskReloadListener.getKey(entry.getValue()).toString());
                    baseMasks.add((JsonElement)maskObj);
                }
                JsonObject maskObj = new JsonObject();
                JointMask.JointMaskSet defaultMask = jointMaskEntry.getDefaultMask();
                maskObj.addProperty("livingmotion", LivingMotions.ALL.toString());
                maskObj.addProperty("type", JointMaskReloadListener.getKey(defaultMask).toString());
                baseMasks.add((JsonElement)maskObj);
            });
            baseJson.add("masks", (JsonElement)baseMasks);
            JsonObject compositeJson = new JsonObject();
            compositeJson.addProperty("priority", this.getPriority().toString());
            JsonArray compositeMasks = new JsonArray();
            multilayer.getProperty(ClientAnimationProperties.JOINT_MASK).ifPresent(jointMaskEntry -> {
                for (Map.Entry<LivingMotion, JointMask.JointMaskSet> entry : jointMaskEntry.getEntries()) {
                    JsonObject maskObj = new JsonObject();
                    maskObj.addProperty("livingmotion", entry.getKey().toString());
                    maskObj.addProperty("type", JointMaskReloadListener.getKey(entry.getValue()).toString());
                    compositeMasks.add((JsonElement)maskObj);
                }
                JsonObject maskObj = new JsonObject();
                JointMask.JointMaskSet defaultMask = jointMaskEntry.getDefaultMask();
                maskObj.addProperty("livingmotion", LivingMotions.ALL.toString());
                maskObj.addProperty("type", JointMaskReloadListener.getKey(defaultMask).toString());
                compositeMasks.add((JsonElement)maskObj);
            });
            baseJson.add("masks", (JsonElement)compositeMasks);
            multilayerJson.add("base", (JsonElement)baseJson);
            multilayerJson.add("composite", (JsonElement)compositeJson);
            propertiesJson.add("multilayer", (JsonElement)multilayerJson);
        }, () -> {
            JsonArray masks = new JsonArray();
            this.getProperty(ClientAnimationProperties.JOINT_MASK).ifPresent(jointMaskEntry -> {
                for (Map.Entry<LivingMotion, JointMask.JointMaskSet> entry : jointMaskEntry.getEntries()) {
                    JsonObject maskObj = new JsonObject();
                    maskObj.addProperty("livingmotion", entry.getKey().toString());
                    maskObj.addProperty("type", JointMaskReloadListener.getKey(entry.getValue()).toString());
                    masks.add((JsonElement)maskObj);
                }
                JsonObject maskObj = new JsonObject();
                JointMask.JointMaskSet defaultMask = jointMaskEntry.getDefaultMask();
                maskObj.addProperty("livingmotion", LivingMotions.ALL.toString());
                maskObj.addProperty("type", JointMaskReloadListener.getKey(defaultMask).toString());
                masks.add((JsonElement)maskObj);
            });
            if (!masks.isEmpty()) {
                propertiesJson.add("masks", (JsonElement)masks);
            }
            propertiesJson.addProperty("layer", this.getLayerType().toString());
            propertiesJson.addProperty("priority", this.getPriority().toString());
        });
        this.fakeAnimation = fakeAnimation;
        return fakeAnimation;
    }
}

