/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.HashSet;
import java.util.Map;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.animation.types.MainFrameAnimation;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class HitAnimation
extends MainFrameAnimation {
    public HitAnimation(float convertTime, String path, Armature armature) {
        this(convertTime, path, armature, false);
    }

    public HitAnimation(float convertTime, String path, Armature armature, boolean noRegister) {
        super(convertTime, path, armature, noRegister);
        this.stateSpectrumBlueprint.clear().newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.TURNING_LOCKED, true).addState(EntityState.MOVEMENT_LOCKED, true).addState(EntityState.UPDATE_LIVING_MOTION, false).addState(EntityState.CAN_BASIC_ATTACK, false).addState(EntityState.CAN_SKILL_EXECUTION, false).addState(EntityState.INACTION, true).addState(EntityState.HURT_LEVEL, 1);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        entitypatch.cancelAnyAction();
    }

    @Override
    public void setLinkAnimation(DynamicAnimation fromAnimation, Pose startPose, boolean isOnSameLayer, float convertTimeModifier, LivingEntityPatch<?> entitypatch, LinkAnimation dest) {
        dest.resetNextStartTime();
        dest.getTransfroms().clear();
        dest.setTotalTime(convertTimeModifier + this.convertTime);
        dest.setConnectedAnimations(fromAnimation, this);
        Map<String, JointTransform> data1 = startPose.getJointTransformData();
        Map<String, JointTransform> data2 = super.getPoseByTime(entitypatch, 0.0f, 0.0f).getJointTransformData();
        Map<String, JointTransform> data3 = super.getPoseByTime(entitypatch, this.getTotalTime(), 0.0f).getJointTransformData();
        HashSet<String> joint1 = new HashSet<String>(data1.keySet());
        joint1.removeIf(jointName -> !fromAnimation.hasTransformFor((String)jointName));
        HashSet<String> joint2 = new HashSet<String>(data2.keySet());
        joint2.removeIf(jointName -> !this.hasTransformFor((String)jointName));
        joint1.addAll(joint2);
        for (String jointName2 : joint1) {
            if (!data1.containsKey(jointName2) || !data2.containsKey(jointName2)) continue;
            Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, data1.get(jointName2)), new Keyframe(this.convertTime, data2.get(jointName2)), new Keyframe(this.convertTime + 0.033f, data3.get(jointName2)), new Keyframe(convertTimeModifier + this.convertTime, data3.get(jointName2))};
            TransformSheet sheet = new TransformSheet(keyframes);
            dest.getAnimationClip().addJointTransform(jointName2, sheet);
        }
    }

    @Override
    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        return super.getPoseByTime(entitypatch, this.getTotalTime() - 1.0E-6f, 0.0f);
    }
}

