/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.events;

import com.legacy.dungeons_plus.DPConfig;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.dungeons_plus.data.advancement.ThrownItemHitBlockTrigger;
import com.legacy.dungeons_plus.data.providers.DPAdvancementProv;
import com.legacy.dungeons_plus.data.providers.DPLangProvider;
import com.legacy.dungeons_plus.data.providers.DPLootProv;
import com.legacy.dungeons_plus.data.providers.DPModelProv;
import com.legacy.dungeons_plus.data.providers.DPRecipeProvider;
import com.legacy.dungeons_plus.data.providers.DPTagProv;
import com.legacy.dungeons_plus.registry.DPBlocks;
import com.legacy.dungeons_plus.registry.DPDamageSources;
import com.legacy.dungeons_plus.registry.DPItems;
import com.legacy.dungeons_plus.registry.DPLoot;
import com.legacy.dungeons_plus.registry.DPStructures;
import com.legacy.structure_gel.api.data.providers.RegistrarDatapackEntriesProvider;
import com.legacy.structure_gel.api.entity.EntityAccessHelper;
import com.legacy.structure_gel.api.events.RegisterLootTableAliasEvent;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class DPCommonEvents {

    @Mod.EventBusSubscriber(modid="dungeons_plus", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBus {
        @SubscribeEvent
        protected static void commonInit(FMLCommonSetupEvent event) {
            ModList modList = ModList.get();
            DungeonsPlus.isWaystonesLoaded = modList.isLoaded("waystones");
            event.enqueueWork(() -> CriteriaTriggers.m_10595_((CriterionTrigger)ThrownItemHitBlockTrigger.TRIGGER));
        }

        @SubscribeEvent
        protected static void commonInit(BuildCreativeModeTabContentsEvent event) {
            ResourceKey tab = event.getTabKey();
            MutableHashedLinkedMap entries = event.getEntries();
            if (tab.equals((Object)CreativeModeTabs.f_256797_)) {
                event.accept(DPItems.FROSTED_COWL);
                event.accept(DPItems.LEVIATHAN_BLADE);
                event.accept(DPItems.WARPED_AXE);
                event.accept(DPItems.SOUL_CANNON);
            } else if (tab.equals((Object)CreativeModeTabs.f_256776_)) {
                ModBus.insertAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, List.of((ItemLike)DPBlocks.GRANITE_IRON_ORE.get()), (ItemLike)Items.f_41834_);
                ModBus.insertAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, List.of((ItemLike)DPBlocks.GRANITE_GOLD_ORE.get()), (ItemLike)Items.f_41833_);
            }
        }

        protected static void insertAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries, List<ItemLike> items, ItemLike target) {
            ItemStack currentStack = null;
            for (Map.Entry e : entries) {
                if (((ItemStack)e.getKey()).m_41720_() != target) continue;
                currentStack = (ItemStack)e.getKey();
                break;
            }
            for (ItemLike item : items) {
                ItemStack itemStack = currentStack;
                currentStack = item.m_5456_().m_7968_();
                entries.putAfter((Object)itemStack, (Object)currentStack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }

        @SubscribeEvent
        protected static void registerLootTableAlias(RegisterLootTableAliasEvent event) {
            event.register(DungeonsPlus.locate("tower/common"), DPLoot.Tower.CHEST_COMMON);
            event.register(DungeonsPlus.locate("tower/barrel"), DPLoot.Tower.CHEST_BARREL);
            event.register(DungeonsPlus.locate("tower/vex"), DPLoot.Tower.CHEST_VEX);
            event.register(DungeonsPlus.locate("tower/vex_map"), DPLoot.Tower.CHEST_VEX_MAP);
            event.register(DungeonsPlus.locate("tower/skeleton"), DPLoot.Tower.ENTITY_SKELETON);
            event.register(DungeonsPlus.locate("tower/spider"), DPLoot.Tower.ENTITY_SPIDER);
            event.register(DungeonsPlus.locate("tower/zombie"), DPLoot.Tower.ENTITY_ZOMBIE);
            event.register(DungeonsPlus.locate("reanimated_ruins/common"), DPLoot.ReanimatedRuins.CHEST_COMMON);
            event.register(DungeonsPlus.locate("reanimated_ruins/desert"), DPLoot.ReanimatedRuins.CHEST_DESERT);
            event.register(DungeonsPlus.locate("reanimated_ruins/desert_map"), DPLoot.ReanimatedRuins.CHEST_DESERT_MAP);
            event.register(DungeonsPlus.locate("reanimated_ruins/frozen"), DPLoot.ReanimatedRuins.CHEST_FROZEN);
            event.register(DungeonsPlus.locate("reanimated_ruins/frozen_map"), DPLoot.ReanimatedRuins.CHEST_FROZEN_MAP);
            event.register(DungeonsPlus.locate("reanimated_ruins/mossy"), DPLoot.ReanimatedRuins.CHEST_MOSSY);
            event.register(DungeonsPlus.locate("reanimated_ruins/mossy_map"), DPLoot.ReanimatedRuins.CHEST_MOSSY_MAP);
            event.register(DungeonsPlus.locate("reanimated_ruins/skeleton"), DPLoot.ReanimatedRuins.ENTITY_SKELETON);
            event.register(DungeonsPlus.locate("reanimated_ruins/zombie"), DPLoot.ReanimatedRuins.ENTITY_ZOMBIE);
            event.register(DungeonsPlus.locate("leviathan/common"), DPLoot.Leviathan.CHEST_COMMON);
            event.register(DungeonsPlus.locate("leviathan/rare"), DPLoot.Leviathan.CHEST_RARE);
            event.register(DungeonsPlus.locate("leviathan/husk"), DPLoot.Leviathan.ENTITY_HUSK);
            event.register(DungeonsPlus.locate("snowy_temple/common"), DPLoot.SnowyTemple.CHEST_COMMON);
            event.register(DungeonsPlus.locate("snowy_temple/rare"), DPLoot.SnowyTemple.CHEST_RARE);
            event.register(DungeonsPlus.locate("snowy_temple/stray"), DPLoot.SnowyTemple.ENTITY_STRAY);
            event.register(DungeonsPlus.locate("warped_garden/common"), DPLoot.WarpedGarden.CHEST_COMMON);
            event.register(DungeonsPlus.locate("warped_garden/rare"), DPLoot.WarpedGarden.CHEST_RARE);
            event.register(DungeonsPlus.locate("soul_prison/common"), DPLoot.SoulPrison.CHEST_COMMON);
            event.register(DungeonsPlus.locate("soul_prison/rare"), DPLoot.SoulPrison.CHEST_RARE);
            event.register(DungeonsPlus.locate("soul_prison/golden_armor"), DPLoot.SoulPrison.CHEST_GOLDEN_ARMOR);
        }

        @SubscribeEvent
        protected static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            PackOutput output = gen.getPackOutput();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            boolean server = event.includeServer();
            boolean client = event.includeClient();
            RegistrarDatapackEntriesProvider registrarProv = RegistrarHandler.createGenerator((PackOutput)output, (String)"dungeons_plus", (String[])new String[0]);
            gen.addProvider(server, (DataProvider)registrarProv);
            CompletableFuture lookup = registrarProv.getLookupProvider();
            DPTagProv.BlockProv blockTagProv = new DPTagProv.BlockProv(output, lookup, existingFileHelper);
            gen.addProvider(server, (DataProvider)blockTagProv);
            gen.addProvider(server, (DataProvider)new DPTagProv.ItemProv(output, lookup, blockTagProv.m_274426_(), existingFileHelper));
            gen.addProvider(server, (DataProvider)new DPTagProv.EntityTypeProv(output, lookup, existingFileHelper));
            gen.addProvider(server, (DataProvider)new DPTagProv.StructureProv(output, lookup, existingFileHelper));
            gen.addProvider(server, (DataProvider)new DPTagProv.BiomeProv(output, lookup, existingFileHelper));
            gen.addProvider(server, (DataProvider)new DPTagProv.EnchantmentProv(output, lookup, existingFileHelper));
            gen.addProvider(server, (DataProvider)new DPTagProv.DamageTypeProv(output, lookup, existingFileHelper));
            gen.addProvider(server, (DataProvider)new DPAdvancementProv(output, lookup, existingFileHelper));
            gen.addProvider(server, (DataProvider)new DPLootProv(output));
            gen.addProvider(server, (DataProvider)new DPRecipeProvider(output));
            gen.addProvider(client, (DataProvider)new DPLangProvider(output, lookup));
            gen.addProvider(client, (DataProvider)new DPModelProv.States(output, existingFileHelper));
            gen.addProvider(client, (DataProvider)new DPModelProv.ItemModels(output, existingFileHelper));
            gen.addProvider(true, (DataProvider)ModBus.packMcmeta(output, "Dungeons Plus resources"));
        }

        private static final PackMetadataGenerator packMcmeta(PackOutput output, String description) {
            Map packVersionMap = Stream.of(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0)));
            int packVersion = packVersionMap.get(PackType.SERVER_DATA);
            return new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)description), packVersion, packVersionMap));
        }
    }

    @Mod.EventBusSubscriber(modid="dungeons_plus", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeBus {
        @SubscribeEvent
        protected static void onFinalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
            Mob entity = event.getEntity();
            ServerLevelAccessor levelAccessor = event.getLevel();
            ForgeBus.ifInStructurePiece(levelAccessor, (Entity)entity, EntityType.f_20458_, DPStructures.LEVIATHAN, e -> {
                RandomSource rand;
                if (((Boolean)DPConfig.COMMON.husksDropSand.get()).booleanValue()) {
                    EntityAccessHelper.setDeathLootTable((Mob)e, (ResourceLocation)DPLoot.Leviathan.ENTITY_HUSK);
                }
                if ((double)(rand = e.m_217043_()).m_188501_() < (Double)DPConfig.COMMON.huskLeviathanBladeChance.get()) {
                    ItemStack stack = ((Item)DPItems.LEVIATHAN_BLADE.get()).m_7968_();
                    stack.m_41721_(rand.m_188503_(stack.m_41720_().getMaxDamage(stack)));
                    e.m_8061_(EquipmentSlot.MAINHAND, stack);
                    e.m_21409_(EquipmentSlot.MAINHAND, 0.12f);
                }
            });
            ForgeBus.ifInStructurePiece(levelAccessor, (Entity)entity, EntityType.f_20481_, DPStructures.SNOWY_TEMPLE, e -> {
                RandomSource rand;
                if (((Boolean)DPConfig.COMMON.straysDropIce.get()).booleanValue()) {
                    EntityAccessHelper.setDeathLootTable((Mob)e, (ResourceLocation)DPLoot.SnowyTemple.ENTITY_STRAY);
                }
                if ((double)(rand = e.m_217043_()).m_188501_() < (Double)DPConfig.COMMON.strayFrostedCowlChance.get()) {
                    ItemStack stack = ((Item)DPItems.FROSTED_COWL.get()).m_7968_();
                    stack.m_41721_(rand.m_188503_(stack.m_41720_().getMaxDamage(stack)));
                    e.m_8061_(EquipmentSlot.HEAD, stack);
                    e.m_21409_(EquipmentSlot.HEAD, 0.12f);
                }
            });
            ForgeBus.ifInStructurePiece(levelAccessor, (Entity)entity, EntityType.f_20562_, DPStructures.WARPED_GARDEN, e -> {
                Optional opTag;
                RandomSource rand = e.m_217043_();
                if ((double)rand.m_188501_() < (Double)DPConfig.COMMON.drownedWarpedAxeChance.get()) {
                    ItemStack stack = ((Item)DPItems.WARPED_AXE.get()).m_7968_();
                    stack.m_41721_(rand.m_188503_(stack.m_41720_().getMaxDamage(stack)));
                    e.m_8061_(EquipmentSlot.MAINHAND, stack);
                    e.m_21409_(EquipmentSlot.MAINHAND, 0.12f);
                }
                if ((double)rand.m_188501_() < (Double)DPConfig.COMMON.drownedCoralChance.get() && (opTag = levelAccessor.m_9598_().m_175515_(Registries.f_256747_).m_203431_(BlockTags.f_13051_)).isPresent() && ((HolderSet.Named)opTag.get()).m_203632_() > 0) {
                    e.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)((Holder)((HolderSet.Named)opTag.get()).m_213653_(rand).get()).m_203334_()));
                    e.m_21409_(EquipmentSlot.OFFHAND, 1.0f);
                }
            });
            ForgeBus.ifInStructurePiece(levelAccessor, (Entity)entity, EntityType.f_20524_, DPStructures.SOUL_PRISON, e -> {
                RandomSource rand = e.m_217043_();
                if ((double)rand.m_188501_() < (Double)DPConfig.COMMON.skeletonSoulCannonChance.get()) {
                    ItemStack stack = ((Item)DPItems.SOUL_CANNON.get()).m_7968_();
                    stack.m_41721_(rand.m_188503_(stack.m_41720_().getMaxDamage(stack)));
                    e.m_8061_(EquipmentSlot.OFFHAND, stack);
                    e.m_21409_(EquipmentSlot.OFFHAND, 0.3f);
                }
            });
        }

        @SubscribeEvent
        protected static void onJoinLevel(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            Level level = event.getLevel();
            if (level instanceof ServerLevelAccessor) {
                ServerLevelAccessor levelAccessor = (ServerLevelAccessor)level;
                ForgeBus.ifInStructure(levelAccessor, entity, EntityType.f_20453_, DPStructures.SOUL_PRISON, e -> e.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)e, Player.class, true, false)));
                ForgeBus.ifInStructurePiece(levelAccessor, entity, EntityType.f_20566_, DPStructures.END_RUINS, e -> e.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)e, Player.class, true, false)));
            }
        }

        private static <T extends Entity> void ifInStructurePiece(ServerLevelAccessor levelAccessor, Entity entity, EntityType<T> entityTest, StructureRegistrar<?> structure, Consumer<T> consumer) {
            if (entity.m_6095_().equals(entityTest) && StructureAccessHelper.isInStructurePiece((ServerLevelAccessor)levelAccessor, (StructureType)structure.getType(), (BlockPos)entity.m_20183_())) {
                consumer.accept(entity);
            }
        }

        private static <T extends Entity> void ifInStructure(ServerLevelAccessor levelAccessor, Entity entity, EntityType<T> entityTest, StructureRegistrar<?> structure, Consumer<T> consumer) {
            if (entity.m_6095_().equals(entityTest) && StructureAccessHelper.isInStructure((ServerLevelAccessor)levelAccessor, (StructureType)structure.getType(), (BlockPos)entity.m_20183_())) {
                consumer.accept(entity);
            }
        }

        @SubscribeEvent
        protected static void onEffectApply(MobEffectEvent.Applicable event) {
            if (event.getEffectInstance().m_19544_() == MobEffects.f_19597_) {
                ArrayList<ItemStack> strayArmors = new ArrayList<ItemStack>(1);
                LivingEntity entity = event.getEntity();
                for (ItemStack stack : entity.m_6168_()) {
                    ArmorItem armor;
                    Item item = stack.m_41720_();
                    if (!(item instanceof ArmorItem) || (armor = (ArmorItem)item).m_40401_() != DPItems.DPArmors.STRAY) continue;
                    strayArmors.add(stack);
                }
                int size = strayArmors.size();
                if (size > 0) {
                    event.setResult(Event.Result.DENY);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        RandomSource rand = serverPlayer.m_217043_();
                        ((ItemStack)strayArmors.get(rand.m_188503_(size))).m_220157_(2, rand, serverPlayer);
                    }
                }
            }
        }

        @SubscribeEvent
        protected static void onLevelLoad(LevelEvent.Load event) {
            Level level;
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof Level && (level = (Level)levelAccessor).m_46472_().equals((Object)Level.f_46428_)) {
                DPDamageSources.instance = new DPDamageSources(level.m_9598_());
            }
        }
    }
}

