/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.override;

import java.util.Arrays;
import net.optifine.BlockPosM;
import net.optifine.render.RenderEnv;
import net.optifine.util.ArrayCache;

public class ChunkCacheOF
implements cll {
    private final fla chunkCache;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int sizeXZ;
    private int[] combinedLights;
    private dbq[] blockStates;
    private cnf[] biomes;
    private final int arraySize;
    private RenderEnv renderEnv;
    private static final ArrayCache cacheCombinedLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache cacheBlockStates = new ArrayCache(dbq.class, 16);
    private static final ArrayCache cacheBiomes = new ArrayCache(cnf.class, 16);

    public ChunkCacheOF(fla chunkCache, gt posFromIn, gt posToIn, int subIn) {
        this.chunkCache = chunkCache;
        int minChunkX = posFromIn.u() - subIn >> 4;
        int minChunkY = posFromIn.v() - subIn >> 4;
        int minChunkZ = posFromIn.w() - subIn >> 4;
        int maxChunkX = posToIn.u() + subIn >> 4;
        int maxChunkY = posToIn.v() + subIn >> 4;
        int maxChunkZ = posToIn.w() + subIn >> 4;
        this.sizeX = maxChunkX - minChunkX + 1 << 4;
        this.sizeY = maxChunkY - minChunkY + 1 << 4;
        this.sizeZ = maxChunkZ - minChunkZ + 1 << 4;
        this.sizeXZ = this.sizeX * this.sizeZ;
        this.arraySize = this.sizeX * this.sizeY * this.sizeZ;
        this.posX = minChunkX << 4;
        this.posY = minChunkY << 4;
        this.posZ = minChunkZ << 4;
    }

    public int getPositionIndex(gt pos) {
        int dx = pos.u() - this.posX;
        if (dx < 0 || dx >= this.sizeX) {
            return -1;
        }
        int dy = pos.v() - this.posY;
        if (dy < 0 || dy >= this.sizeY) {
            return -1;
        }
        int dz = pos.w() - this.posZ;
        if (dz < 0 || dz >= this.sizeZ) {
            return -1;
        }
        return dy * this.sizeXZ + dz * this.sizeX + dx;
    }

    public int a(cmr type, gt pos) {
        return this.chunkCache.a(type, pos);
    }

    public dbq a_(gt pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.blockStates == null) {
            return this.chunkCache.a_(pos);
        }
        dbq iblockstate = this.blockStates[index];
        if (iblockstate == null) {
            this.blockStates[index] = iblockstate = this.chunkCache.a_(pos);
        }
        return iblockstate;
    }

    public void renderStart() {
        if (this.combinedLights == null) {
            this.combinedLights = (int[])cacheCombinedLights.allocate(this.arraySize);
        }
        if (this.blockStates == null) {
            this.blockStates = (dbq[])cacheBlockStates.allocate(this.arraySize);
        }
        if (this.biomes == null) {
            this.biomes = (cnf[])cacheBiomes.allocate(this.arraySize);
        }
        Arrays.fill(this.combinedLights, -1);
        Arrays.fill(this.blockStates, null);
        Arrays.fill(this.biomes, null);
        this.loadBlockStates();
    }

    private void loadBlockStates() {
        if (this.sizeX != 48 || this.sizeY != 48 || this.sizeZ != 48) {
            return;
        }
        ddy chunk = this.chunkCache.getChunk(1, 1);
        BlockPosM pos = new BlockPosM();
        for (int y = 16; y < 32; ++y) {
            int dy = y * this.sizeXZ;
            for (int z2 = 16; z2 < 32; ++z2) {
                int dz = z2 * this.sizeX;
                for (int x = 16; x < 32; ++x) {
                    dbq bs;
                    pos.setXyz(this.posX + x, this.posY + y, this.posZ + z2);
                    int index = dy + dz + x;
                    this.blockStates[index] = bs = chunk.a_((gt)pos);
                }
            }
        }
    }

    public void renderFinish() {
        cacheCombinedLights.free((Object)this.combinedLights);
        this.combinedLights = null;
        cacheBlockStates.free((Object)this.blockStates);
        this.blockStates = null;
        cacheBiomes.free((Object)this.biomes);
        this.biomes = null;
    }

    public int[] getCombinedLights() {
        return this.combinedLights;
    }

    public cnf getBiome(gt pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.biomes == null) {
            return this.chunkCache.getBiome(pos);
        }
        cnf biome = this.biomes[index];
        if (biome == null) {
            this.biomes[index] = biome = this.chunkCache.getBiome(pos);
        }
        return biome;
    }

    public cze c_(gt pos) {
        return this.chunkCache.c_(pos);
    }

    public boolean g(gt pos) {
        return this.chunkCache.g(pos);
    }

    public dwj b_(gt pos) {
        return this.a_(pos).r();
    }

    public int a(gt blockPosIn, clt colorResolverIn) {
        return this.chunkCache.a(blockPosIn, colorResolverIn);
    }

    public dwa l_() {
        return this.chunkCache.l_();
    }

    public RenderEnv getRenderEnv() {
        return this.renderEnv;
    }

    public void setRenderEnv(RenderEnv renderEnv) {
        this.renderEnv = renderEnv;
    }

    public float a(gz directionIn, boolean shadeIn) {
        return this.chunkCache.a(directionIn, shadeIn);
    }

    public int w_() {
        return this.chunkCache.w_();
    }

    public int v_() {
        return this.chunkCache.v_();
    }
}

