/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import net.optifine.Config;
import net.optifine.ConnectedTextures;
import net.optifine.NaturalProperties;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class NaturalTextures {
    private static NaturalProperties[] propertiesByIndex = new NaturalProperties[0];

    public static void update() {
        propertiesByIndex = new NaturalProperties[0];
        if (!Config.isNaturalTextures()) {
            return;
        }
        String fileName = "optifine/natural.properties";
        try {
            add loc = new add(fileName);
            if (!Config.hasResource((add)loc)) {
                Config.dbg((String)("NaturalTextures: configuration \"" + fileName + "\" not found"));
                return;
            }
            boolean defaultConfig = Config.isFromDefaultResourcePack((add)loc);
            InputStream in = Config.getResourceStream((add)loc);
            ArrayList<NaturalProperties> list = new ArrayList<NaturalProperties>(256);
            String configStr = Config.readInputStream((InputStream)in);
            in.close();
            String[] configLines = Config.tokenize((String)configStr, (String)"\n\r");
            if (defaultConfig) {
                Config.dbg((String)("Natural Textures: Parsing default configuration \"" + fileName + "\""));
                Config.dbg((String)"Natural Textures: Valid only for textures from default resource pack");
            } else {
                Config.dbg((String)("Natural Textures: Parsing configuration \"" + fileName + "\""));
            }
            int countTextures = 0;
            ftb textureMapBlocks = TextureUtils.getTextureMapBlocks();
            for (int i = 0; i < configLines.length; ++i) {
                String line = configLines[i].trim();
                if (line.startsWith("#")) continue;
                String[] strs = Config.tokenize((String)line, (String)"=");
                if (strs.length != 2) {
                    Config.warn((String)("Natural Textures: Invalid \"" + fileName + "\" line: " + line));
                    continue;
                }
                String key = strs[0].trim();
                String type = strs[1].trim();
                String texName = key;
                ftc ts = textureMapBlocks.getUploadedSprite("minecraft:block/" + texName);
                if (ts == null) {
                    Config.warn((String)("Natural Textures: Texture not found: \"" + fileName + "\" line: " + line));
                    continue;
                }
                int tileNum = ts.getIndexInMap();
                if (tileNum < 0) {
                    Config.warn((String)("Natural Textures: Invalid \"" + fileName + "\" line: " + line));
                    continue;
                }
                if (defaultConfig && !Config.isFromDefaultResourcePack((add)new add("textures/block/" + texName + ".png"))) {
                    return;
                }
                NaturalProperties props = new NaturalProperties(type);
                if (!props.isValid()) continue;
                while (list.size() <= tileNum) {
                    list.add(null);
                }
                list.set(tileNum, props);
                ++countTextures;
            }
            propertiesByIndex = list.toArray(new NaturalProperties[list.size()]);
            if (countTextures > 0) {
                Config.dbg((String)("NaturalTextures: " + countTextures));
            }
        }
        catch (FileNotFoundException e) {
            Config.warn((String)("NaturalTextures: configuration \"" + fileName + "\" not found"));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static fja getNaturalTexture(gt blockPosIn, fja quad) {
        ftc sprite = quad.a();
        if (sprite == null) {
            return quad;
        }
        NaturalProperties nps = NaturalTextures.getNaturalProperties((ftc)sprite);
        if (nps == null) {
            return quad;
        }
        int side = ConnectedTextures.getSide((gz)quad.e());
        int rand = Config.getRandom((gt)blockPosIn, (int)side);
        int rotate = 0;
        boolean flipU = false;
        if (nps.rotation > 1) {
            rotate = rand & 3;
        }
        if (nps.rotation == 2) {
            rotate = rotate / 2 * 2;
        }
        if (nps.flip) {
            flipU = (rand & 4) != 0;
        }
        return nps.getQuad(quad, rotate, flipU);
    }

    public static NaturalProperties getNaturalProperties(ftc icon) {
        if (!(icon instanceof ftc)) {
            return null;
        }
        ftc ts = icon;
        int tileNum = ts.getIndexInMap();
        if (tileNum < 0 || tileNum >= propertiesByIndex.length) {
            return null;
        }
        NaturalProperties props = propertiesByIndex[tileNum];
        return props;
    }
}

