/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.config;

import net.optifine.Config;
import net.optifine.shaders.config.ShaderLine;
import net.optifine.util.StrUtils;
import org.joml.Vector4f;

public class ShaderLine {
    private Type type;
    private String name;
    private String value;
    private String line;

    public ShaderLine(Type type, String name, String value, String line) {
        this.type = type;
        this.name = name;
        this.value = value;
        this.line = line;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isUniform() {
        return this.type == Type.UNIFORM;
    }

    public boolean isUniform(String name) {
        return this.isUniform() && name.equals(this.name);
    }

    public boolean isAttribute() {
        return this.type == Type.ATTRIBUTE;
    }

    public boolean isAttribute(String name) {
        return this.isAttribute() && name.equals(this.name);
    }

    public boolean isProperty() {
        return this.type == Type.PROPERTY;
    }

    public boolean isConstInt() {
        return this.type == Type.CONST_INT;
    }

    public boolean isConstFloat() {
        return this.type == Type.CONST_FLOAT;
    }

    public boolean isConstBool() {
        return this.type == Type.CONST_BOOL;
    }

    public boolean isExtension() {
        return this.type == Type.EXTENSION;
    }

    public boolean isConstVec2() {
        return this.type == Type.CONST_VEC2;
    }

    public boolean isConstVec4() {
        return this.type == Type.CONST_VEC4;
    }

    public boolean isConstIVec3() {
        return this.type == Type.CONST_IVEC3;
    }

    public boolean isLayout() {
        return this.type == Type.LAYOUT;
    }

    public boolean isLayout(String name) {
        return this.isLayout() && name.equals(this.name);
    }

    public boolean isProperty(String name) {
        return this.isProperty() && name.equals(this.name);
    }

    public boolean isProperty(String name, String value) {
        return this.isProperty(name) && value.equals(this.value);
    }

    public boolean isConstInt(String name) {
        return this.isConstInt() && name.equals(this.name);
    }

    public boolean isConstIntSuffix(String suffix) {
        return this.isConstInt() && this.name.endsWith(suffix);
    }

    public boolean isConstIVec3(String name) {
        return this.isConstIVec3() && name.equals(this.name);
    }

    public boolean isConstFloat(String name) {
        return this.isConstFloat() && name.equals(this.name);
    }

    public boolean isConstBool(String name) {
        return this.isConstBool() && name.equals(this.name);
    }

    public boolean isExtension(String name) {
        return this.isExtension() && name.equals(this.name);
    }

    public boolean isConstBoolSuffix(String suffix) {
        return this.isConstBool() && this.name.endsWith(suffix);
    }

    public boolean isConstBoolSuffix(String suffix, boolean val) {
        return this.isConstBoolSuffix(suffix) && this.getValueBool() == val;
    }

    public boolean isConstBool(String name1, String name2) {
        return this.isConstBool(name1) || this.isConstBool(name2);
    }

    public boolean isConstBool(String name1, String name2, String name3) {
        return this.isConstBool(name1) || this.isConstBool(name2) || this.isConstBool(name3);
    }

    public boolean isConstBool(String name, boolean val) {
        return this.isConstBool(name) && this.getValueBool() == val;
    }

    public boolean isConstBool(String name1, String name2, boolean val) {
        return this.isConstBool(name1, name2) && this.getValueBool() == val;
    }

    public boolean isConstBool(String name1, String name2, String name3, boolean val) {
        return this.isConstBool(name1, name2, name3) && this.getValueBool() == val;
    }

    public boolean isConstVec2(String name) {
        return this.isConstVec2() && name.equals(this.name);
    }

    public boolean isConstVec4Suffix(String suffix) {
        return this.isConstVec4() && this.name.endsWith(suffix);
    }

    public int getValueInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e2) {
            throw new NumberFormatException("Invalid integer: " + this.value + ", line: " + this.line);
        }
    }

    public float getValueFloat() {
        try {
            return Float.parseFloat(this.value);
        }
        catch (NumberFormatException e2) {
            throw new NumberFormatException("Invalid float: " + this.value + ", line: " + this.line);
        }
    }

    public hy getValueIVec3() {
        if (this.value == null) {
            return null;
        }
        String str = this.value.trim();
        str = StrUtils.removePrefix((String)str, (String)"ivec3");
        String[] parts = Config.tokenize((String)(str = StrUtils.trim((String)str, (String)" ()")), (String)", ");
        if (parts.length != 3) {
            return null;
        }
        int[] vals = new int[3];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            int val = Config.parseInt((String)part, (int)Integer.MIN_VALUE);
            if (val == Integer.MIN_VALUE) {
                return null;
            }
            vals[i] = val;
        }
        return new hy(vals[0], vals[1], vals[2]);
    }

    public edd getValueVec2() {
        if (this.value == null) {
            return null;
        }
        String str = this.value.trim();
        str = StrUtils.removePrefix((String)str, (String)"vec2");
        String[] parts = Config.tokenize((String)(str = StrUtils.trim((String)str, (String)" ()")), (String)", ");
        if (parts.length != 2) {
            return null;
        }
        float[] fs = new float[2];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            float f2 = Config.parseFloat((String)(part = StrUtils.removeSuffix((String)part, (String[])new String[]{"F", "f"})), (float)Float.MAX_VALUE);
            if (f2 == Float.MAX_VALUE) {
                return null;
            }
            fs[i] = f2;
        }
        return new edd(fs[0], fs[1]);
    }

    public Vector4f getValueVec4() {
        if (this.value == null) {
            return null;
        }
        String str = this.value.trim();
        str = StrUtils.removePrefix((String)str, (String)"vec4");
        String[] parts = Config.tokenize((String)(str = StrUtils.trim((String)str, (String)" ()")), (String)", ");
        if (parts.length != 4) {
            return null;
        }
        float[] fs = new float[4];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            float f2 = Config.parseFloat((String)(part = StrUtils.removeSuffix((String)part, (String[])new String[]{"F", "f"})), (float)Float.MAX_VALUE);
            if (f2 == Float.MAX_VALUE) {
                return null;
            }
            fs[i] = f2;
        }
        return new Vector4f(fs[0], fs[1], fs[2], fs[3]);
    }

    public boolean getValueBool() {
        String valLow = this.value.toLowerCase();
        if (!valLow.equals("true") && !valLow.equals("false")) {
            throw new RuntimeException("Invalid boolean: " + this.value + ", line: " + this.line);
        }
        return Boolean.valueOf(this.value);
    }

    public String toString() {
        return this.line;
    }
}

