/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.expr;

import java.util.HashMap;
import java.util.Map;
import net.optifine.Config;
import net.optifine.expr.ExpressionType;
import net.optifine.expr.FunctionType;
import net.optifine.expr.IExpression;
import net.optifine.expr.IExpressionBool;
import net.optifine.expr.IExpressionFloat;
import net.optifine.expr.IParameters;
import net.optifine.expr.Parameters;
import net.optifine.expr.ParametersVariable;
import net.optifine.shaders.uniform.Smoother;
import net.optifine.util.FrameEvent;
import net.optifine.util.MathUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum FunctionType {
    PLUS(10, ExpressionType.FLOAT, "+", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    MINUS(10, ExpressionType.FLOAT, "-", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    MUL(11, ExpressionType.FLOAT, "*", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    DIV(11, ExpressionType.FLOAT, "/", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    MOD(11, ExpressionType.FLOAT, "%", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    NEG(12, ExpressionType.FLOAT, "neg", new ExpressionType[]{ExpressionType.FLOAT}),
    PI(ExpressionType.FLOAT, "pi", new ExpressionType[0]),
    SIN(ExpressionType.FLOAT, "sin", new ExpressionType[]{ExpressionType.FLOAT}),
    COS(ExpressionType.FLOAT, "cos", new ExpressionType[]{ExpressionType.FLOAT}),
    ASIN(ExpressionType.FLOAT, "asin", new ExpressionType[]{ExpressionType.FLOAT}),
    ACOS(ExpressionType.FLOAT, "acos", new ExpressionType[]{ExpressionType.FLOAT}),
    TAN(ExpressionType.FLOAT, "tan", new ExpressionType[]{ExpressionType.FLOAT}),
    ATAN(ExpressionType.FLOAT, "atan", new ExpressionType[]{ExpressionType.FLOAT}),
    ATAN2(ExpressionType.FLOAT, "atan2", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    TORAD(ExpressionType.FLOAT, "torad", new ExpressionType[]{ExpressionType.FLOAT}),
    TODEG(ExpressionType.FLOAT, "todeg", new ExpressionType[]{ExpressionType.FLOAT}),
    MIN(ExpressionType.FLOAT, "min", (IParameters)new ParametersVariable().first(new ExpressionType[]{ExpressionType.FLOAT}).repeat(new ExpressionType[]{ExpressionType.FLOAT})),
    MAX(ExpressionType.FLOAT, "max", (IParameters)new ParametersVariable().first(new ExpressionType[]{ExpressionType.FLOAT}).repeat(new ExpressionType[]{ExpressionType.FLOAT})),
    CLAMP(ExpressionType.FLOAT, "clamp", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT, ExpressionType.FLOAT}),
    ABS(ExpressionType.FLOAT, "abs", new ExpressionType[]{ExpressionType.FLOAT}),
    FLOOR(ExpressionType.FLOAT, "floor", new ExpressionType[]{ExpressionType.FLOAT}),
    CEIL(ExpressionType.FLOAT, "ceil", new ExpressionType[]{ExpressionType.FLOAT}),
    EXP(ExpressionType.FLOAT, "exp", new ExpressionType[]{ExpressionType.FLOAT}),
    FRAC(ExpressionType.FLOAT, "frac", new ExpressionType[]{ExpressionType.FLOAT}),
    LOG(ExpressionType.FLOAT, "log", new ExpressionType[]{ExpressionType.FLOAT}),
    POW(ExpressionType.FLOAT, "pow", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    RANDOM(ExpressionType.FLOAT, "random", (IParameters)new ParametersVariable().repeat(new ExpressionType[]{ExpressionType.FLOAT}).maxCount(1)),
    ROUND(ExpressionType.FLOAT, "round", new ExpressionType[]{ExpressionType.FLOAT}),
    SIGNUM(ExpressionType.FLOAT, "signum", new ExpressionType[]{ExpressionType.FLOAT}),
    SQRT(ExpressionType.FLOAT, "sqrt", new ExpressionType[]{ExpressionType.FLOAT}),
    FMOD(ExpressionType.FLOAT, "fmod", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    LERP(ExpressionType.FLOAT, "lerp", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT, ExpressionType.FLOAT}),
    TIME(ExpressionType.FLOAT, "time", new ExpressionType[0]),
    PRINT(ExpressionType.FLOAT, "print", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT, ExpressionType.FLOAT}),
    PRINTB(ExpressionType.BOOL, "printb", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT, ExpressionType.BOOL}),
    IF(ExpressionType.FLOAT, "if", (IParameters)new ParametersVariable().first(new ExpressionType[]{ExpressionType.BOOL, ExpressionType.FLOAT}).repeat(new ExpressionType[]{ExpressionType.BOOL, ExpressionType.FLOAT}).last(new ExpressionType[]{ExpressionType.FLOAT})),
    NOT(12, ExpressionType.BOOL, "!", new ExpressionType[]{ExpressionType.BOOL}),
    AND(3, ExpressionType.BOOL, "&&", new ExpressionType[]{ExpressionType.BOOL, ExpressionType.BOOL}),
    OR(2, ExpressionType.BOOL, "||", new ExpressionType[]{ExpressionType.BOOL, ExpressionType.BOOL}),
    GREATER(8, ExpressionType.BOOL, ">", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    GREATER_OR_EQUAL(8, ExpressionType.BOOL, ">=", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    SMALLER(8, ExpressionType.BOOL, "<", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    SMALLER_OR_EQUAL(8, ExpressionType.BOOL, "<=", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    EQUAL(7, ExpressionType.BOOL, "==", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    NOT_EQUAL(7, ExpressionType.BOOL, "!=", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    BETWEEN(7, ExpressionType.BOOL, "between", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT, ExpressionType.FLOAT}),
    EQUALS(7, ExpressionType.BOOL, "equals", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT, ExpressionType.FLOAT}),
    IN(ExpressionType.BOOL, "in", (IParameters)new ParametersVariable().first(new ExpressionType[]{ExpressionType.FLOAT}).repeat(new ExpressionType[]{ExpressionType.FLOAT}).last(new ExpressionType[]{ExpressionType.FLOAT})),
    SMOOTH(ExpressionType.FLOAT, "smooth", (IParameters)new ParametersVariable().first(new ExpressionType[]{ExpressionType.FLOAT}).repeat(new ExpressionType[]{ExpressionType.FLOAT}).maxCount(4)),
    TRUE(ExpressionType.BOOL, "true", new ExpressionType[0]),
    FALSE(ExpressionType.BOOL, "false", new ExpressionType[0]),
    VEC2(ExpressionType.FLOAT_ARRAY, "vec2", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT}),
    VEC3(ExpressionType.FLOAT_ARRAY, "vec3", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT, ExpressionType.FLOAT}),
    VEC4(ExpressionType.FLOAT_ARRAY, "vec4", new ExpressionType[]{ExpressionType.FLOAT, ExpressionType.FLOAT, ExpressionType.FLOAT, ExpressionType.FLOAT});

    private int precedence;
    private ExpressionType expressionType;
    private String name;
    private IParameters parameters;
    public static FunctionType[] VALUES;
    private static final Map<Integer, Float> mapSmooth;

    private FunctionType(ExpressionType expressionType, String name, ExpressionType ... parameterTypes) {
        this(string, n2, 0, expressionType, name, parameterTypes);
    }

    private FunctionType(int precedence, ExpressionType expressionType, String name, ExpressionType ... parameterTypes) {
        this(string, n2, precedence, expressionType, name, (IParameters)new Parameters(parameterTypes));
    }

    private FunctionType(ExpressionType expressionType, String name, IParameters parameters) {
        this(string, n2, 0, expressionType, name, parameters);
    }

    private FunctionType(int precedence, ExpressionType expressionType, String name, IParameters parameters) {
        this.precedence = precedence;
        this.expressionType = expressionType;
        this.name = name;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public ExpressionType getExpressionType() {
        return this.expressionType;
    }

    public IParameters getParameters() {
        return this.parameters;
    }

    public int getParameterCount(IExpression[] arguments) {
        return this.parameters.getParameterTypes(arguments).length;
    }

    public ExpressionType[] getParameterTypes(IExpression[] arguments) {
        return this.parameters.getParameterTypes(arguments);
    }

    public float evalFloat(IExpression[] args) {
        switch (1.$SwitchMap$net$optifine$expr$FunctionType[this.ordinal()]) {
            case 1: {
                return FunctionType.evalFloat((IExpression[])args, (int)0) + FunctionType.evalFloat((IExpression[])args, (int)1);
            }
            case 2: {
                return FunctionType.evalFloat((IExpression[])args, (int)0) - FunctionType.evalFloat((IExpression[])args, (int)1);
            }
            case 3: {
                return FunctionType.evalFloat((IExpression[])args, (int)0) * FunctionType.evalFloat((IExpression[])args, (int)1);
            }
            case 4: {
                return FunctionType.evalFloat((IExpression[])args, (int)0) / FunctionType.evalFloat((IExpression[])args, (int)1);
            }
            case 5: {
                float modX = FunctionType.evalFloat((IExpression[])args, (int)0);
                float modY = FunctionType.evalFloat((IExpression[])args, (int)1);
                return modX - modY * (float)((int)(modX / modY));
            }
            case 6: {
                return -FunctionType.evalFloat((IExpression[])args, (int)0);
            }
            case 7: {
                return (float)Math.PI;
            }
            case 8: {
                return apj.a((float)FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 9: {
                return apj.b((float)FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 10: {
                return MathUtils.asin((float)FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 11: {
                return MathUtils.acos((float)FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 12: {
                return (float)Math.tan(FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 13: {
                return (float)Math.atan(FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 14: {
                return (float)apj.d((double)FunctionType.evalFloat((IExpression[])args, (int)0), (double)FunctionType.evalFloat((IExpression[])args, (int)1));
            }
            case 15: {
                return MathUtils.toRad((float)FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 16: {
                return MathUtils.toDeg((float)FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 17: {
                return this.getMin(args);
            }
            case 18: {
                return this.getMax(args);
            }
            case 19: {
                return apj.a((float)FunctionType.evalFloat((IExpression[])args, (int)0), (float)FunctionType.evalFloat((IExpression[])args, (int)1), (float)FunctionType.evalFloat((IExpression[])args, (int)2));
            }
            case 20: {
                return apj.e((float)FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 21: {
                return (float)Math.exp(FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 22: {
                return apj.d((float)FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 23: {
                return apj.f((float)FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 24: {
                return apj.h((float)FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 25: {
                return (float)Math.log(FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 26: {
                return (float)Math.pow(FunctionType.evalFloat((IExpression[])args, (int)0), FunctionType.evalFloat((IExpression[])args, (int)1));
            }
            case 27: {
                if (args.length > 0) {
                    float seed = FunctionType.evalFloat((IExpression[])args, (int)0);
                    int seedInt = Float.floatToIntBits(seed);
                    int randInt = Config.intHash((int)seedInt);
                    return (float)Math.abs(randInt) / 2.1474836E9f;
                }
                return (float)Math.random();
            }
            case 28: {
                return Math.round(FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 29: {
                return Math.signum(FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 30: {
                return apj.c((float)FunctionType.evalFloat((IExpression[])args, (int)0));
            }
            case 31: {
                float fmodX = FunctionType.evalFloat((IExpression[])args, (int)0);
                float fmodY = FunctionType.evalFloat((IExpression[])args, (int)1);
                return fmodX - fmodY * (float)apj.d((float)(fmodX / fmodY));
            }
            case 32: {
                float k2 = FunctionType.evalFloat((IExpression[])args, (int)0);
                float x = FunctionType.evalFloat((IExpression[])args, (int)1);
                float y = FunctionType.evalFloat((IExpression[])args, (int)2);
                return apj.i((float)k2, (float)x, (float)y);
            }
            case 33: {
                emh mc = emh.N();
                fdj world = mc.s;
                if (world == null) {
                    return 0.0f;
                }
                return (float)(world.U() % 24000L) + fhz.getRenderPartialTicks();
            }
            case 34: {
                int printId = (int)FunctionType.evalFloat((IExpression[])args, (int)0);
                int printFrames = (int)FunctionType.evalFloat((IExpression[])args, (int)1);
                float printVal = FunctionType.evalFloat((IExpression[])args, (int)2);
                if (FrameEvent.isActive((String)("CEM-PRINT-" + printId), (int)printFrames)) {
                    Config.dbg((String)("CEM print(" + printId + ") = " + printVal));
                }
                return printVal;
            }
            case 35: {
                int countChecks = (args.length - 1) / 2;
                for (int i = 0; i < countChecks; ++i) {
                    int index = i * 2;
                    if (!FunctionType.evalBool((IExpression[])args, (int)index)) continue;
                    return FunctionType.evalFloat((IExpression[])args, (int)(index + 1));
                }
                return FunctionType.evalFloat((IExpression[])args, (int)(countChecks * 2));
            }
            case 36: {
                int id = (int)FunctionType.evalFloat((IExpression[])args, (int)0);
                float valRaw = FunctionType.evalFloat((IExpression[])args, (int)1);
                float valFadeUp = args.length > 2 ? FunctionType.evalFloat((IExpression[])args, (int)2) : 1.0f;
                float valFadeDown = args.length > 3 ? FunctionType.evalFloat((IExpression[])args, (int)3) : valFadeUp;
                float valSmooth = Smoother.getSmoothValue((int)id, (float)valRaw, (float)valFadeUp, (float)valFadeDown);
                return valSmooth;
            }
        }
        Config.warn((String)("Unknown function type: " + this));
        return 0.0f;
    }

    private float getMin(IExpression[] exprs) {
        if (exprs.length == 2) {
            return Math.min(FunctionType.evalFloat((IExpression[])exprs, (int)0), FunctionType.evalFloat((IExpression[])exprs, (int)1));
        }
        float valMin = FunctionType.evalFloat((IExpression[])exprs, (int)0);
        for (int i = 1; i < exprs.length; ++i) {
            float valExpr = FunctionType.evalFloat((IExpression[])exprs, (int)i);
            if (!(valExpr < valMin)) continue;
            valMin = valExpr;
        }
        return valMin;
    }

    private float getMax(IExpression[] exprs) {
        if (exprs.length == 2) {
            return Math.max(FunctionType.evalFloat((IExpression[])exprs, (int)0), FunctionType.evalFloat((IExpression[])exprs, (int)1));
        }
        float valMax = FunctionType.evalFloat((IExpression[])exprs, (int)0);
        for (int i = 1; i < exprs.length; ++i) {
            float valExpr = FunctionType.evalFloat((IExpression[])exprs, (int)i);
            if (!(valExpr > valMax)) continue;
            valMax = valExpr;
        }
        return valMax;
    }

    private static float evalFloat(IExpression[] exprs, int index) {
        IExpressionFloat ef = (IExpressionFloat)exprs[index];
        float val = ef.eval();
        return val;
    }

    public boolean evalBool(IExpression[] args) {
        switch (1.$SwitchMap$net$optifine$expr$FunctionType[this.ordinal()]) {
            case 37: {
                return true;
            }
            case 38: {
                return false;
            }
            case 39: {
                return !FunctionType.evalBool((IExpression[])args, (int)0);
            }
            case 40: {
                return FunctionType.evalBool((IExpression[])args, (int)0) && FunctionType.evalBool((IExpression[])args, (int)1);
            }
            case 41: {
                return FunctionType.evalBool((IExpression[])args, (int)0) || FunctionType.evalBool((IExpression[])args, (int)1);
            }
            case 42: {
                return FunctionType.evalFloat((IExpression[])args, (int)0) > FunctionType.evalFloat((IExpression[])args, (int)1);
            }
            case 43: {
                return FunctionType.evalFloat((IExpression[])args, (int)0) >= FunctionType.evalFloat((IExpression[])args, (int)1);
            }
            case 44: {
                return FunctionType.evalFloat((IExpression[])args, (int)0) < FunctionType.evalFloat((IExpression[])args, (int)1);
            }
            case 45: {
                return FunctionType.evalFloat((IExpression[])args, (int)0) <= FunctionType.evalFloat((IExpression[])args, (int)1);
            }
            case 46: {
                return FunctionType.evalFloat((IExpression[])args, (int)0) == FunctionType.evalFloat((IExpression[])args, (int)1);
            }
            case 47: {
                return FunctionType.evalFloat((IExpression[])args, (int)0) != FunctionType.evalFloat((IExpression[])args, (int)1);
            }
            case 48: {
                float val = FunctionType.evalFloat((IExpression[])args, (int)0);
                return val >= FunctionType.evalFloat((IExpression[])args, (int)1) && val <= FunctionType.evalFloat((IExpression[])args, (int)2);
            }
            case 49: {
                float diff = FunctionType.evalFloat((IExpression[])args, (int)0) - FunctionType.evalFloat((IExpression[])args, (int)1);
                float delta = FunctionType.evalFloat((IExpression[])args, (int)2);
                return Math.abs(diff) <= delta;
            }
            case 50: {
                float valIn = FunctionType.evalFloat((IExpression[])args, (int)0);
                for (int i = 1; i < args.length; ++i) {
                    float valCheck = FunctionType.evalFloat((IExpression[])args, (int)i);
                    if (valIn != valCheck) continue;
                    return true;
                }
                return false;
            }
            case 51: {
                int printId = (int)FunctionType.evalFloat((IExpression[])args, (int)0);
                int printFrames = (int)FunctionType.evalFloat((IExpression[])args, (int)1);
                boolean printVal = FunctionType.evalBool((IExpression[])args, (int)2);
                if (FrameEvent.isActive((String)("CEM-PRINTB-" + printId), (int)printFrames)) {
                    Config.dbg((String)("CEM printb(" + printId + ") = " + printVal));
                }
                return printVal;
            }
        }
        Config.warn((String)("Unknown function type: " + this));
        return false;
    }

    private static boolean evalBool(IExpression[] exprs, int index) {
        IExpressionBool eb = (IExpressionBool)exprs[index];
        boolean val = eb.eval();
        return val;
    }

    public float[] evalFloatArray(IExpression[] args) {
        switch (1.$SwitchMap$net$optifine$expr$FunctionType[this.ordinal()]) {
            case 52: {
                return new float[]{FunctionType.evalFloat((IExpression[])args, (int)0), FunctionType.evalFloat((IExpression[])args, (int)1)};
            }
            case 53: {
                return new float[]{FunctionType.evalFloat((IExpression[])args, (int)0), FunctionType.evalFloat((IExpression[])args, (int)1), FunctionType.evalFloat((IExpression[])args, (int)2)};
            }
            case 54: {
                return new float[]{FunctionType.evalFloat((IExpression[])args, (int)0), FunctionType.evalFloat((IExpression[])args, (int)1), FunctionType.evalFloat((IExpression[])args, (int)2), FunctionType.evalFloat((IExpression[])args, (int)3)};
            }
        }
        Config.warn((String)("Unknown function type: " + this));
        return null;
    }

    public static FunctionType parse(String str) {
        for (int i = 0; i < VALUES.length; ++i) {
            FunctionType ef = VALUES[i];
            if (!ef.getName().equals(str)) continue;
            return ef;
        }
        return null;
    }

    static {
        VALUES = FunctionType.values();
        mapSmooth = new HashMap();
    }
}

