/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.RendererCache;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<bfl, czg> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(bfl entityType, String name, float shadowSize) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, null);
    }

    public ModelAdapter(bfl entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(czg tileEntityType, String name, float shadowSize) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(czg tileEntityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, aliases);
    }

    public ModelAdapter(Either<bfl, czg> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<bfl, czg> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract fao makeModel();

    public abstract fcr getModelRenderer(fao var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(fao var1, float var2, RendererCache var3, int var4);

    public boolean setTextureLocation(IEntityRenderer er, add textureLocation) {
        return false;
    }

    public fcr[] getModelRenderers(fao model) {
        String[] names = this.getModelRendererNames();
        ArrayList<fcr> list = new ArrayList<fcr>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            fcr mr = this.getModelRenderer(model, name);
            if (mr == null) continue;
            list.add(mr);
        }
        fcr[] mrs = list.toArray(new fcr[list.size()]);
        return mrs;
    }

    public static fcr bakeModelLayer(fcp loc) {
        return emh.N().an().getContext().a(loc);
    }
}

