/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.Log;
import net.optifine.RandomEntities;
import net.optifine.RandomEntityContext;
import net.optifine.RandomEntityProperties;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.RendererCache;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.Either;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomEntityModels {
    private static boolean active = false;
    private static Map<bfl, RandomEntityProperties<IEntityRenderer>> mapEntityProperties = new HashMap();
    private static Map<czg, RandomEntityProperties<IEntityRenderer>> mapBlockEntityProperties = new HashMap();
    private static int matchingRuleIndex;
    private static Map<bfl, fnd> originalEntityRenderMap;
    private static Map<czg, fkd> originalTileEntityRenderMap;
    private static Map<cwg.a, fbp> originalSkullModelMap;
    private static List<czg> customTileEntityTypes;
    private static ezb customBookModel;
    private static boolean debugModels;
    public static final String PREFIX_OPTIFINE_CEM = "optifine/cem/";
    public static final String SUFFIX_JEM = ".jem";
    public static final String SUFFIX_PROPERTIES = ".properties";

    public static void update() {
        Map entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        Map skullModelMap = CustomEntityModels.getSkullModelMap();
        if (entityRenderMap == null) {
            Config.warn((String)"Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn((String)"Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        skullModelMap.clear();
        customTileEntityTypes.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        skullModelMap.putAll(originalSkullModelMap);
        fhs blockEntityRenderer = emh.N().ap().getBlockEntityRenderer();
        blockEntityRenderer.k = new fbx(ModelAdapter.bakeModelLayer((fcp)fcq.bC));
        frk.customParrotModel = null;
        customBookModel = null;
        fkd.CACHED_TYPES.clear();
        if (emh.N().s != null) {
            Iterable entities = emh.N().s.e();
            for (bfh entity : entities) {
                Map modelVariables = entity.aj().modelVariables;
                if (modelVariables == null) continue;
                modelVariables.clear();
            }
        }
        mapEntityProperties.clear();
        mapBlockEntityProperties.clear();
        if (!Config.isCustomEntityModels()) {
            return;
        }
        RandomEntityContext.Models context = new RandomEntityContext.Models();
        RendererCache rendererCache = context.getRendererCache();
        add[] locs = CustomEntityModels.getModelLocations();
        for (int i = 0; i < locs.length; ++i) {
            add loc = locs[i];
            Config.dbg((String)("CustomEntityModel: " + loc.a()));
            IEntityRenderer rc2 = CustomEntityModels.parseEntityRender((add)loc, (RendererCache)rendererCache, (int)0);
            if (rc2 == null) continue;
            Either type = rc2.getType();
            if (rc2 instanceof fnd) {
                foq pr;
                fas pm;
                fpr tr;
                fbx tm;
                entityRenderMap.put((bfl)type.getLeft().get(), (fnd)rc2);
                rendererCache.put((bfl)type.getLeft().get(), 0, (fnd)rc2);
                if (rc2 instanceof fpr && (tm = (fbx)Reflector.getFieldValue((Object)(tr = (fpr)rc2), (ReflectorField)Reflector.RenderTrident_modelTrident)) != null) {
                    blockEntityRenderer.k = tm;
                }
                if (rc2 instanceof foq && (pm = (fas)(pr = (foq)rc2).a()) != null) {
                    frk.customParrotModel = pm;
                }
            } else if (rc2 instanceof fkd) {
                tileEntityRenderMap.put((czg)type.getRight().get(), (fkd)rc2);
                rendererCache.put((czg)type.getRight().get(), 0, (fkd)rc2);
                if (rc2 instanceof fkl) {
                    fkl etr = (fkl)rc2;
                    ezb bm = (ezb)Reflector.getFieldValue((Object)etr, (ReflectorField)Reflector.TileEntityEnchantmentTableRenderer_modelBook);
                    CustomEntityModels.setEnchantmentScreenBookModel((ezb)bm);
                }
                customTileEntityTypes.add((czg)type.getRight().get());
            } else {
                Config.warn((String)("Unknown renderer type: " + rc2.getClass().getName()));
            }
            active = true;
        }
        CustomEntityModels.updateRandomProperties((RandomEntityContext.Models)context);
    }

    private static void updateRandomProperties(RandomEntityContext.Models context) {
        String[] prefixes = new String[]{"optifine/cem/"};
        String[] suffixes = new String[]{".jem", ".properties"};
        String[] names = CustomModelRegistry.getModelNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
            Either type = modelAdapter.getType();
            RandomEntityProperties props = CustomEntityModels.makeProperties((String)name, (RandomEntityContext.Models)context);
            if (props == null) {
                props = CustomEntityModels.makeProperties((String)(name + "/" + name), (RandomEntityContext.Models)context);
            }
            if (props == null) continue;
            if (type.getLeft().isPresent()) {
                mapEntityProperties.put((bfl)type.getLeft().get(), props);
                continue;
            }
            mapBlockEntityProperties.put((czg)type.getRight().get(), props);
        }
    }

    private static RandomEntityProperties makeProperties(String name, RandomEntityContext.Models context) {
        RandomEntityProperties props;
        add locJem = new add("optifine/cem/" + name + ".jem");
        add locProps = new add("optifine/cem/" + name + ".properties");
        if (Config.hasResource((add)locProps) && (props = RandomEntityProperties.parse((add)locProps, (add)locJem, (RandomEntityContext)context)) != null) {
            return props;
        }
        if (!Config.hasResource((add)locJem)) {
            return null;
        }
        int[] variants = RandomEntities.getLocationsVariants((add)locJem, (boolean)false, (RandomEntityContext)context);
        if (variants == null) {
            return null;
        }
        RandomEntityProperties props2 = new RandomEntityProperties(locJem.a(), locJem, variants, (RandomEntityContext)context);
        if (!props2.isValid(locJem.a())) {
            return null;
        }
        return props2;
    }

    private static void setEnchantmentScreenBookModel(ezb bookModel) {
        customBookModel = bookModel;
    }

    private static Map<bfl, fnd> getEntityRenderMap() {
        fnc rm2 = emh.N().an();
        Map entityRenderMap = rm2.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<czg, fkd> getTileEntityRenderMap() {
        fkc blockEntityRenderDispatcher = emh.N().ao();
        Map tileEntityRenderMap = blockEntityRenderDispatcher.getBlockEntityRenderMap();
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static Map<cwg.a, fbp> getSkullModelMap() {
        HashMap skullModelMap = fkr.models;
        if (skullModelMap == null) {
            Config.warn((String)"Field not found: SkullBlockRenderer.MODELS");
            skullModelMap = new HashMap();
        }
        if (originalSkullModelMap == null) {
            originalSkullModelMap = new HashMap(skullModelMap);
        }
        return skullModelMap;
    }

    private static add[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<add> resourceLocations = new ArrayList<add>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String path = prefix + name + suffix;
            add loc = new add(path);
            if (!Config.hasResource((add)loc) && !debugModels) continue;
            resourceLocations.add(loc);
        }
        add[] locs = resourceLocations.toArray(new add[resourceLocations.size()]);
        return locs;
    }

    public static IEntityRenderer parseEntityRender(add location, RendererCache rendererCache, int index) {
        try {
            if (debugModels && index == 0) {
                return CustomEntityModels.makeDebugEntityRenderer((add)location, (RendererCache)rendererCache, (int)index);
            }
            JsonObject jo = CustomEntityModelParser.loadJson((add)location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender((JsonObject)jo, (String)location.a(), (RendererCache)rendererCache, (int)index);
            return render;
        }
        catch (IOException e2) {
            Config.error((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
        catch (JsonParseException e3) {
            Config.error((String)(((Object)((Object)e3)).getClass().getName() + ": " + e3.getMessage()));
            return null;
        }
        catch (Exception e4) {
            Log.warn((String)("Error loading CEM: " + location), (Throwable)e4);
            return null;
        }
    }

    private static IEntityRenderer makeDebugEntityRenderer(add loc, RendererCache rendererCache, int index) {
        String path = loc.a();
        String nameJem = StrUtils.removePrefix((String)path, (String)"optifine/cem/");
        String name = StrUtils.removeSuffix((String)nameJem, (String)".jem");
        ModelAdapter ma = CustomModelRegistry.getModelAdapter((String)name);
        fao model = ma.makeModel();
        cel[] colors = cel.values();
        int offset = Math.abs(loc.hashCode()) % 256;
        String[] partNames = ma.getModelRendererNames();
        for (int i = 0; i < partNames.length; ++i) {
            String partName = partNames[i];
            fcr part = ma.getModelRenderer(model, partName);
            if (part == null) continue;
            cel col = colors[(i + offset) % colors.length];
            add locTexture = new add("textures/block/" + col.c() + "_stained_glass.png");
            part.setTextureLocation(locTexture);
            Config.dbg((String)("  " + partName + ": " + col.c()));
        }
        IEntityRenderer er = ma.makeEntityRender(model, ma.getShadowSize(), rendererCache, index);
        if (er == null) {
            return null;
        }
        er.setType(ma.getType());
        return er;
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path, RendererCache rendererCache, int index) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender((JsonObject)obj, (String)path);
        String name = cer.getName();
        name = StrUtils.trimTrailing((String)name, (String)"0123456789");
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
        CustomEntityModels.checkNull((Object)modelAdapter, (String)("Entity not found: " + name));
        Either type = modelAdapter.getType();
        CustomEntityModels.checkNull((Object)type, (String)("Entity type not found: " + name));
        IEntityRenderer render = CustomEntityModels.makeEntityRender((ModelAdapter)modelAdapter, (CustomEntityRenderer)cer, (RendererCache)rendererCache, (int)index);
        if (render == null) {
            return null;
        }
        render.setType(type);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer, RendererCache rendererCache, int index) {
        fao model;
        add textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (fao)model, (CustomModelRenderer[])modelRenderers, (ModelResolver)mr)) {
            return null;
        }
        IEntityRenderer r = modelAdapter.makeEntityRender(model, shadowSize, rendererCache, index);
        if (r == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            CustomEntityModels.setTextureLocation((ModelAdapter)modelAdapter, (fao)model, (IEntityRenderer)r, (add)textureLocation);
        }
        return r;
    }

    private static void setTextureLocation(ModelAdapter modelAdapter, fao model, IEntityRenderer er, add textureLocation) {
        if (modelAdapter.setTextureLocation(er, textureLocation)) {
            return;
        }
        if (er instanceof fof) {
            er.setLocationTextureCustom(textureLocation);
            return;
        }
        CustomEntityModels.setTextureTopModelRenderers((ModelAdapter)modelAdapter, (fao)model, (add)textureLocation);
    }

    public static void setTextureTopModelRenderers(ModelAdapter modelAdapter, fao model, add textureLocation) {
        String[] parts = modelAdapter.getModelRendererNames();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            fcr modelRenderer = modelAdapter.getModelRenderer(model, part);
            if (modelRenderer == null || modelRenderer.getTextureLocation() != null) continue;
            modelRenderer.setTextureLocation(textureLocation);
        }
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, fao model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        for (int i = 0; i < modelRenderers.length; ++i) {
            CustomModelRenderer cmr = modelRenderers[i];
            if (CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (fao)model, (CustomModelRenderer)cmr, (ModelResolver)mr)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, fao model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        fcr parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn((String)("Model part not found: " + modelPart + ", model: " + model));
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.m != null) {
                parent.m.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.n != null) {
                fcr[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                HashSet childModelKeys = new HashSet(parent.n.keySet());
                for (String key : childModelKeys) {
                    fcr mr = (fcr)parent.n.get(key);
                    if (setMrs.contains(mr)) continue;
                    parent.n.remove(key);
                }
            }
        }
        String childName = parent.getUniqueChildModelName("CEM-" + modelPart);
        parent.addChildModel(childName, customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize((IModelResolver)modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static boolean isCustomModel(dbq blockStateIn) {
        for (int i = 0; i < customTileEntityTypes.size(); ++i) {
            czg type = (czg)customTileEntityTypes.get(i);
            if (!type.a(blockStateIn)) continue;
            return true;
        }
        return false;
    }

    public static void onRenderScreen(etd screen) {
        if (customBookModel != null && screen instanceof euu) {
            euu es = (euu)screen;
            Reflector.GuiEnchantment_bookModel.setValue((Object)es, (Object)customBookModel);
        }
    }

    public static fnd getEntityRenderer(bfh entityIn, fnd renderer) {
        if (mapEntityProperties.isEmpty()) {
            return renderer;
        }
        IRandomEntity randomEntity = RandomEntities.getRandomEntity((bfh)entityIn);
        if (randomEntity == null) {
            return renderer;
        }
        RandomEntityProperties props = (RandomEntityProperties)mapEntityProperties.get(entityIn.ae());
        if (props == null) {
            return renderer;
        }
        IEntityRenderer ier = (IEntityRenderer)props.getResource(randomEntity, (Object)renderer);
        if (!(ier instanceof fnd)) {
            return null;
        }
        matchingRuleIndex = props.getMatchingRuleIndex();
        fnd er = (fnd)ier;
        return er;
    }

    public static fkd getBlockEntityRenderer(cze entityIn, fkd renderer) {
        if (mapBlockEntityProperties.isEmpty()) {
            return renderer;
        }
        IRandomEntity randomEntity = RandomEntities.getRandomBlockEntity((cze)entityIn);
        if (randomEntity == null) {
            return renderer;
        }
        RandomEntityProperties props = (RandomEntityProperties)mapBlockEntityProperties.get(entityIn.u());
        if (props == null) {
            return renderer;
        }
        IEntityRenderer ier = (IEntityRenderer)props.getResource(randomEntity, (Object)renderer);
        if (!(ier instanceof fkd)) {
            return null;
        }
        matchingRuleIndex = props.getMatchingRuleIndex();
        fkd ber = (fkd)ier;
        return ber;
    }

    public static int getMatchingRuleIndex() {
        return matchingRuleIndex;
    }

    static {
        originalEntityRenderMap = null;
        originalTileEntityRenderMap = null;
        originalSkullModelMap = null;
        customTileEntityTypes = new ArrayList();
        debugModels = Boolean.getBoolean("cem.debug.models");
    }
}

