/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private bfh entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<gt> setLitChunkPos = new HashSet();
    private gt.a blockPosMutable = new gt.a();

    public DynamicLight(bfh entity) {
        this.entity = entity;
        this.offsetY = entity.cE();
    }

    public void update(fie renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.dl() - 0.5;
        double posY = this.entity.dn() - 0.5 + this.offsetY;
        double posZ = this.entity.dr() - 0.5;
        int lightLevel = DynamicLights.getLightLevel((bfh)this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet setNewPos = new HashSet();
        if (lightLevel > 0) {
            gz dirX = (apj.a((double)posX) & 0xF) >= 8 ? gz.f : gz.e;
            gz dirY = (apj.a((double)posY) & 0xF) >= 8 ? gz.b : gz.a;
            gz dirZ = (apj.a((double)posZ) & 0xF) >= 8 ? gz.d : gz.c;
            gt chunkPos = gt.a((double)posX, (double)posY, (double)posZ);
            fky.c chunk = renderGlobal.getRenderChunk(chunkPos);
            gt chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            fky.c chunkX = renderGlobal.getRenderChunk(chunkPosX);
            gt chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            fky.c chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            gt chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            fky.c chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            gt chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            fky.c chunkY = renderGlobal.getRenderChunk(chunkPosY);
            gt chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            fky.c chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            gt chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            fky.c chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            gt chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            fky.c chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private gt getChunkPos(fky.c renderChunk, gt pos, gz facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(fky.c renderChunk, Set<gt> setPrevPos, Set<gt> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        fky.b compiledChunk = renderChunk.d();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
            renderChunk.setNeedsBackgroundPriorityUpdate(true);
        }
        gt pos = renderChunk.f().i();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(fie renderGlobal) {
        for (gt posOld : this.setLitChunkPos) {
            fky.c chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public bfh getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

