/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import net.optifine.Config;

public class MatchProfession {
    private byc profession;
    private int[] levels;

    public MatchProfession(byc profession) {
        this(profession, null);
    }

    public MatchProfession(byc profession, int level) {
        this(profession, new int[]{level});
    }

    public MatchProfession(byc profession, int[] levels) {
        this.profession = profession;
        this.levels = levels;
    }

    public boolean matches(byc prof, int lev) {
        if (this.profession != prof) {
            return false;
        }
        return this.levels == null || Config.equalsOne((int)lev, (int[])this.levels);
    }

    private boolean hasLevel(int lev) {
        if (this.levels == null) {
            return false;
        }
        return Config.equalsOne((int)lev, (int[])this.levels);
    }

    public boolean addLevel(int lev) {
        if (this.levels == null) {
            this.levels = new int[]{lev};
            return true;
        }
        if (this.hasLevel(lev)) {
            return false;
        }
        this.levels = Config.addIntToArray((int[])this.levels, (int)lev);
        return true;
    }

    public byc getProfession() {
        return this.profession;
    }

    public int[] getLevels() {
        return this.levels;
    }

    public static boolean matchesOne(byc prof, int level, MatchProfession[] mps) {
        if (mps == null) {
            return false;
        }
        for (int i = 0; i < mps.length; ++i) {
            MatchProfession mp = mps[i];
            if (!mp.matches(prof, level)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.levels == null) {
            return "" + this.profession;
        }
        return this.profession + ":" + Config.arrayToString((int[])this.levels);
    }
}

