/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.optifine.Config;
import net.optifine.config.BiomeId;
import net.optifine.config.ConnectedParser;
import net.optifine.config.Matches;
import net.optifine.config.RangeListInt;
import net.optifine.render.Blender;
import net.optifine.util.MathUtils;
import net.optifine.util.NumUtils;
import net.optifine.util.SmoothFloat;
import net.optifine.util.TextureUtils;
import org.joml.Matrix4f;

public class CustomSkyLayer {
    public String source = null;
    private int startFadeIn = -1;
    private int endFadeIn = -1;
    private int startFadeOut = -1;
    private int endFadeOut = -1;
    private int blend = 1;
    private boolean rotate = false;
    private float speed = 1.0f;
    private float[] axis = DEFAULT_AXIS;
    private RangeListInt days = null;
    private int daysLoop = 8;
    private boolean weatherClear = true;
    private boolean weatherRain = false;
    private boolean weatherThunder = false;
    public BiomeId[] biomes = null;
    public RangeListInt heights = null;
    private float transition = 1.0f;
    private SmoothFloat smoothPositionBrightness = null;
    public int textureId = -1;
    private cmi lastWorld = null;
    public static final float[] DEFAULT_AXIS = new float[]{1.0f, 0.0f, 0.0f};
    private static final String WEATHER_CLEAR = "clear";
    private static final String WEATHER_RAIN = "rain";
    private static final String WEATHER_THUNDER = "thunder";

    public CustomSkyLayer(Properties props, String defSource) {
        ConnectedParser cp = new ConnectedParser("CustomSky");
        this.source = props.getProperty("source", defSource);
        this.startFadeIn = this.parseTime(props.getProperty("startFadeIn"));
        this.endFadeIn = this.parseTime(props.getProperty("endFadeIn"));
        this.startFadeOut = this.parseTime(props.getProperty("startFadeOut"));
        this.endFadeOut = this.parseTime(props.getProperty("endFadeOut"));
        this.blend = Blender.parseBlend((String)props.getProperty("blend"));
        this.rotate = this.parseBoolean(props.getProperty("rotate"), true);
        this.speed = this.parseFloat(props.getProperty("speed"), 1.0f);
        this.axis = this.parseAxis(props.getProperty("axis"), DEFAULT_AXIS);
        this.days = cp.parseRangeListInt(props.getProperty("days"));
        this.daysLoop = cp.parseInt(props.getProperty("daysLoop"), 8);
        List weatherList = this.parseWeatherList(props.getProperty("weather", WEATHER_CLEAR));
        this.weatherClear = weatherList.contains(WEATHER_CLEAR);
        this.weatherRain = weatherList.contains(WEATHER_RAIN);
        this.weatherThunder = weatherList.contains(WEATHER_THUNDER);
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListIntNeg(props.getProperty("heights"));
        this.transition = this.parseFloat(props.getProperty("transition"), 1.0f);
    }

    private List<String> parseWeatherList(String str) {
        List<String> weatherAllowedList = Arrays.asList(WEATHER_CLEAR, WEATHER_RAIN, WEATHER_THUNDER);
        ArrayList<String> weatherList = new ArrayList<String>();
        String[] weatherStrs = Config.tokenize((String)str, (String)" ");
        for (int i = 0; i < weatherStrs.length; ++i) {
            String token = weatherStrs[i];
            if (!weatherAllowedList.contains(token)) {
                Config.warn((String)("Unknown weather: " + token));
                continue;
            }
            weatherList.add(token);
        }
        return weatherList;
    }

    private int parseTime(String str) {
        if (str == null) {
            return -1;
        }
        String[] strs = Config.tokenize((String)str, (String)":");
        if (strs.length != 2) {
            Config.warn((String)("Invalid time: " + str));
            return -1;
        }
        String hourStr = strs[0];
        String minStr = strs[1];
        int hour = Config.parseInt((String)hourStr, (int)-1);
        int min = Config.parseInt((String)minStr, (int)-1);
        if (hour < 0 || hour > 23 || min < 0 || min > 59) {
            Config.warn((String)("Invalid time: " + str));
            return -1;
        }
        if ((hour -= 6) < 0) {
            hour += 24;
        }
        int time = hour * 1000 + (int)((double)min / 60.0 * 1000.0);
        return time;
    }

    private boolean parseBoolean(String str, boolean defVal) {
        if (str == null) {
            return defVal;
        }
        if (str.toLowerCase().equals("true")) {
            return true;
        }
        if (str.toLowerCase().equals("false")) {
            return false;
        }
        Config.warn((String)("Unknown boolean: " + str));
        return defVal;
    }

    private float parseFloat(String str, float defVal) {
        if (str == null) {
            return defVal;
        }
        float val = Config.parseFloat((String)str, (float)Float.MIN_VALUE);
        if (val == Float.MIN_VALUE) {
            Config.warn((String)("Invalid value: " + str));
            return defVal;
        }
        return val;
    }

    private float[] parseAxis(String str, float[] defVal) {
        if (str == null) {
            return defVal;
        }
        String[] strs = Config.tokenize((String)str, (String)" ");
        if (strs.length != 3) {
            Config.warn((String)("Invalid axis: " + str));
            return defVal;
        }
        float[] fs = new float[3];
        for (int i = 0; i < strs.length; ++i) {
            fs[i] = Config.parseFloat((String)strs[i], (float)Float.MIN_VALUE);
            if (fs[i] != Float.MIN_VALUE) continue;
            Config.warn((String)("Invalid axis: " + str));
            return defVal;
        }
        float ax = fs[0];
        float ay = fs[1];
        float az = fs[2];
        if (ax * ax + ay * ay + az * az < 1.0E-5f) {
            Config.warn((String)("Invalid axis values: " + str));
            return defVal;
        }
        float[] as = new float[]{az, ay, -ax};
        return as;
    }

    public boolean isValid(String path) {
        int timeOff;
        int timeFadeOut;
        int timeOn;
        int timeSum;
        if (this.source == null) {
            Config.warn((String)("No source texture: " + path));
            return false;
        }
        this.source = TextureUtils.fixResourcePath((String)this.source, (String)TextureUtils.getBasePath((String)path));
        if (this.startFadeIn < 0 && this.endFadeIn < 0 && this.startFadeOut < 0 && this.endFadeOut < 0) {
            this.startFadeIn = 0;
            this.endFadeIn = 0;
            this.startFadeOut = 24000;
            this.endFadeOut = 24000;
        }
        if (this.startFadeIn < 0 || this.endFadeIn < 0 || this.endFadeOut < 0) {
            Config.warn((String)"Invalid times, required are: startFadeIn, endFadeIn and endFadeOut.");
            return false;
        }
        int timeFadeIn = this.normalizeTime(this.endFadeIn - this.startFadeIn);
        if (this.startFadeOut < 0) {
            this.startFadeOut = this.normalizeTime(this.endFadeOut - timeFadeIn);
            if (this.timeBetween(this.startFadeOut, this.startFadeIn, this.endFadeIn)) {
                this.startFadeOut = this.endFadeIn;
            }
        }
        if ((timeSum = timeFadeIn + (timeOn = this.normalizeTime(this.startFadeOut - this.endFadeIn)) + (timeFadeOut = this.normalizeTime(this.endFadeOut - this.startFadeOut)) + (timeOff = this.normalizeTime(this.startFadeIn - this.endFadeOut))) != 0 && timeSum != 24000) {
            Config.warn((String)("Invalid fadeIn/fadeOut times, sum is not 24h: " + timeSum));
            return false;
        }
        if (this.speed < 0.0f) {
            Config.warn((String)("Invalid speed: " + this.speed));
            return false;
        }
        if (this.daysLoop <= 0) {
            Config.warn((String)("Invalid daysLoop: " + this.daysLoop));
            return false;
        }
        return true;
    }

    private int normalizeTime(int timeMc) {
        while (timeMc >= 24000) {
            timeMc -= 24000;
        }
        while (timeMc < 0) {
            timeMc += 24000;
        }
        return timeMc;
    }

    public void render(cmi world, ehe matrixStackIn, int timeOfDay, float celestialAngle, float rainStrength, float thunderStrength) {
        float positionBrightness = this.getPositionBrightness(world);
        float weatherBrightness = this.getWeatherBrightness(rainStrength, thunderStrength);
        float fadeBrightness = this.getFadeBrightness(timeOfDay);
        float brightness = positionBrightness * weatherBrightness * fadeBrightness;
        if ((brightness = Config.limit((float)brightness, (float)0.0f, (float)1.0f)) < 1.0E-4f) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (int)this.textureId);
        Blender.setupBlend((int)this.blend, (float)brightness);
        matrixStackIn.a();
        if (this.rotate) {
            float angleDayStart = 0.0f;
            if (this.speed != (float)Math.round(this.speed)) {
                long worldDay = (world.V() + 18000L) / 24000L;
                double anglePerDay = this.speed % 1.0f;
                double angleDayNow = (double)worldDay * anglePerDay;
                angleDayStart = (float)(angleDayNow % 1.0);
            }
            matrixStackIn.rotateDeg(360.0f * (angleDayStart + celestialAngle * this.speed), this.axis[0], this.axis[1], this.axis[2]);
        }
        ehg tess = ehg.a();
        matrixStackIn.rotateDegXp(90.0f);
        matrixStackIn.rotateDegZp(-90.0f);
        this.renderSide(matrixStackIn, tess, 4);
        matrixStackIn.a();
        matrixStackIn.rotateDegXp(90.0f);
        this.renderSide(matrixStackIn, tess, 1);
        matrixStackIn.b();
        matrixStackIn.a();
        matrixStackIn.rotateDegXp(-90.0f);
        this.renderSide(matrixStackIn, tess, 0);
        matrixStackIn.b();
        matrixStackIn.rotateDegZp(90.0f);
        this.renderSide(matrixStackIn, tess, 5);
        matrixStackIn.rotateDegZp(90.0f);
        this.renderSide(matrixStackIn, tess, 2);
        matrixStackIn.rotateDegZp(90.0f);
        this.renderSide(matrixStackIn, tess, 3);
        matrixStackIn.b();
    }

    private float getPositionBrightness(cmi world) {
        if (this.biomes == null && this.heights == null) {
            return 1.0f;
        }
        float positionBrightness = this.getPositionBrightnessRaw(world);
        if (this.smoothPositionBrightness == null) {
            this.smoothPositionBrightness = new SmoothFloat(positionBrightness, this.transition);
        }
        positionBrightness = this.smoothPositionBrightness.getSmoothValue(positionBrightness);
        return positionBrightness;
    }

    private float getPositionBrightnessRaw(cmi world) {
        bfh renderViewEntity = emh.N().al();
        if (renderViewEntity == null) {
            return 0.0f;
        }
        gt pos = renderViewEntity.dg();
        if (this.biomes != null) {
            cnf biome = (cnf)world.v(pos).a();
            if (biome == null) {
                return 0.0f;
            }
            if (!Matches.biome((cnf)biome, (BiomeId[])this.biomes)) {
                return 0.0f;
            }
        }
        if (this.heights != null && !this.heights.isInRange(pos.v())) {
            return 0.0f;
        }
        return 1.0f;
    }

    private float getWeatherBrightness(float rainStrength, float thunderStrength) {
        float clearBrightness = 1.0f - rainStrength;
        float rainBrightness = rainStrength - thunderStrength;
        float thunderBrightness = thunderStrength;
        float weatherBrightness = 0.0f;
        if (this.weatherClear) {
            weatherBrightness += clearBrightness;
        }
        if (this.weatherRain) {
            weatherBrightness += rainBrightness;
        }
        if (this.weatherThunder) {
            weatherBrightness += thunderBrightness;
        }
        weatherBrightness = NumUtils.limit((float)weatherBrightness, (float)0.0f, (float)1.0f);
        return weatherBrightness;
    }

    private float getFadeBrightness(int timeOfDay) {
        if (this.timeBetween(timeOfDay, this.startFadeIn, this.endFadeIn)) {
            int timeFadeIn = this.normalizeTime(this.endFadeIn - this.startFadeIn);
            int timeDiff = this.normalizeTime(timeOfDay - this.startFadeIn);
            return (float)timeDiff / (float)timeFadeIn;
        }
        if (this.timeBetween(timeOfDay, this.endFadeIn, this.startFadeOut)) {
            return 1.0f;
        }
        if (this.timeBetween(timeOfDay, this.startFadeOut, this.endFadeOut)) {
            int timeFadeOut = this.normalizeTime(this.endFadeOut - this.startFadeOut);
            int timeDiff = this.normalizeTime(timeOfDay - this.startFadeOut);
            return 1.0f - (float)timeDiff / (float)timeFadeOut;
        }
        return 0.0f;
    }

    private void renderSide(ehe matrixStackIn, ehg tess, int side) {
        egz wr = tess.c();
        float tx = (float)(side % 3) / 3.0f;
        float ty = (float)(side / 3) / 2.0f;
        Matrix4f matrix4f = matrixStackIn.c().a();
        RenderSystem.setShader(fhz::s);
        wr.a(ehj.b.h, ehc.q);
        this.addVertex(matrix4f, wr, -100.0f, -100.0f, -100.0f, tx, ty);
        this.addVertex(matrix4f, wr, -100.0f, -100.0f, 100.0f, tx, ty + 0.5f);
        this.addVertex(matrix4f, wr, 100.0f, -100.0f, 100.0f, tx + 0.33333334f, ty + 0.5f);
        this.addVertex(matrix4f, wr, 100.0f, -100.0f, -100.0f, tx + 0.33333334f, ty);
        tess.b();
    }

    private void addVertex(Matrix4f matrix4f, egz buffer, float x, float y, float z2, float u, float v) {
        float xt = MathUtils.getTransformX((Matrix4f)matrix4f, (float)x, (float)y, (float)z2, (float)1.0f);
        float yt = MathUtils.getTransformY((Matrix4f)matrix4f, (float)x, (float)y, (float)z2, (float)1.0f);
        float zt = MathUtils.getTransformZ((Matrix4f)matrix4f, (float)x, (float)y, (float)z2, (float)1.0f);
        buffer.a((double)xt, (double)yt, (double)zt).a(u, v).e();
    }

    public boolean isActive(cmi world, int timeOfDay) {
        if (world != this.lastWorld) {
            this.lastWorld = world;
            this.smoothPositionBrightness = null;
        }
        if (this.timeBetween(timeOfDay, this.endFadeOut, this.startFadeIn)) {
            return false;
        }
        if (this.days != null) {
            long timeShift;
            long time = world.V();
            for (timeShift = time - (long)this.startFadeIn; timeShift < 0L; timeShift += (long)(24000 * this.daysLoop)) {
            }
            int day = (int)(timeShift / 24000L);
            int dayOfLoop = day % this.daysLoop;
            if (!this.days.isInRange(dayOfLoop)) {
                return false;
            }
        }
        return true;
    }

    private boolean timeBetween(int timeOfDay, int timeStart, int timeEnd) {
        if (timeStart <= timeEnd) {
            return timeOfDay >= timeStart && timeOfDay <= timeEnd;
        }
        return timeOfDay >= timeStart || timeOfDay <= timeEnd;
    }

    public String toString() {
        return this.source + ", " + this.startFadeIn + "-" + this.endFadeIn + " " + this.startFadeOut + "-" + this.endFadeOut;
    }
}

