/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigCodec;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class ConfigHandler {
    private static ConfigCodec LOADED_CONFIG = new ConfigCodec(true, ConfigCodec.Legacy.DEFAULT, ConfigCodec.Features.DEFAULT, ConfigCodec.Experimental.DEFAULT);

    public static ConfigCodec getConfig() {
        return LOADED_CONFIG;
    }

    public static void load(Path path) {
        block11: {
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                ConfigHandler.write(path);
            }
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonElement json = JsonParser.parseReader((Reader)reader);
                Optional result = ConfigCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result();
                if (result.isPresent()) {
                    LOADED_CONFIG = (ConfigCodec)result.get();
                    break block11;
                }
                throw new JsonParseException("Invalid codec");
            }
            catch (JsonParseException e) {
                Tectonic.LOGGER.error("Couldn't parse config file, resetting to default config");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ConfigHandler.write(path);
    }

    private static void write(Path path) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            JsonElement element = (JsonElement)ConfigCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)LOADED_CONFIG).result().get();
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setIndent("  ");
            ConfigHandler.writeSortedKeys(jsonWriter, element);
            writer.write(ConfigHandler.commentHack(stringWriter.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeSortedKeys(JsonWriter writer, @Nullable JsonElement json) throws IOException {
        if (json != null && !json.isJsonNull()) {
            if (json instanceof JsonPrimitive) {
                JsonPrimitive jsonPrimitive = (JsonPrimitive)json;
                if (jsonPrimitive.isNumber()) {
                    writer.value(jsonPrimitive.getAsNumber());
                } else if (jsonPrimitive.isBoolean()) {
                    writer.value(jsonPrimitive.getAsBoolean());
                } else {
                    writer.value(jsonPrimitive.getAsString());
                }
            } else if (json.isJsonArray()) {
                writer.beginArray();
                for (JsonElement element : json.getAsJsonArray()) {
                    ConfigHandler.writeSortedKeys(writer, element);
                }
                writer.endArray();
            } else {
                if (!json.isJsonObject()) {
                    throw new IllegalArgumentException("Couldn't write " + String.valueOf(json.getClass()));
                }
                writer.beginObject();
                for (Map.Entry<String, JsonElement> elementEntry : ConfigHandler.sort(json.getAsJsonObject().entrySet())) {
                    writer.name(elementEntry.getKey());
                    ConfigHandler.writeSortedKeys(writer, elementEntry.getValue());
                }
                writer.endObject();
            }
        } else {
            writer.nullValue();
        }
    }

    private static Collection<Map.Entry<String, JsonElement>> sort(Collection<Map.Entry<String, JsonElement>> entries) {
        ArrayList<Map.Entry<String, JsonElement>> list = new ArrayList<Map.Entry<String, JsonElement>>(entries);
        list.sort(Map.Entry.comparingByKey(String::compareTo));
        return list;
    }

    private static String commentHack(String json) {
        return json.replaceAll("\"__.\": \"", "// ").replaceAll("\"...__\": \"", "// ").replace("\",", "");
    }
}

