/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic;

import com.mojang.serialization.Codec;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.worldgen.ConfigDensityFunction;
import dev.worldgen.tectonic.worldgen.DynamicReferenceDensityFunction;
import dev.worldgen.tectonic.worldgen.ErosionNoiseDensityFunction;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="tectonic")
public class TectonicNeoforge {
    private static final List<String> enabledPacks = new ArrayList<String>();

    public TectonicNeoforge(IEventBus modEventBus) {
        Tectonic.init((Codec<HolderSet<DensityFunction>>)RegistryCodecs.homogeneousList((ResourceKey)Registries.DENSITY_FUNCTION));
        ConfigHandler.load(FMLPaths.CONFIGDIR.get().resolve("tectonic.json"));
        ConfigHandler.getConfig().enablePacks(ModList.get().isLoaded("terralith"), enabledPacks::add);
        Collections.reverse(enabledPacks);
        modEventBus.addListener(this::registerDensityFunctionTypes);
        modEventBus.addListener(this::registerEnabledPacks);
    }

    private void registerDensityFunctionTypes(RegisterEvent event) {
        event.register(Registries.DENSITY_FUNCTION_TYPE, helper -> helper.register(Tectonic.idOf("config"), (Object)ConfigDensityFunction.CODEC_HOLDER.codec()));
        event.register(Registries.DENSITY_FUNCTION_TYPE, helper -> helper.register(Tectonic.idOf("dynamic_reference"), (Object)DynamicReferenceDensityFunction.CODEC_HOLDER.codec()));
        event.register(Registries.DENSITY_FUNCTION_TYPE, helper -> helper.register(Tectonic.idOf("erosion_noise"), (Object)ErosionNoiseDensityFunction.CODEC_HOLDER.codec()));
    }

    private void registerEnabledPacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            for (String packName : enabledPacks) {
                this.registerDatapack(event, packName);
            }
        }
    }

    private void registerDatapack(AddPackFindersEvent event, String packName) {
        Path resourcePath = ModList.get().getModFileById("tectonic").getFile().findResource(new String[]{"resourcepacks/" + packName.toLowerCase()});
        PackLocationInfo locationInfo = new PackLocationInfo(resourcePath.getFileName().toString(), (Component)Component.translatable((String)("pack_name.tectonic." + packName)), PackSource.BUILT_IN, Optional.empty());
        PackSelectionConfig selectionConfig = new PackSelectionConfig(true, Pack.Position.TOP, false);
        Pack dataPack = Pack.readMetaAndCreate((PackLocationInfo)locationInfo, (Pack.ResourcesSupplier)TectonicNeoforge.createSupplier((PackResources)new PathPackResources(locationInfo, resourcePath)), (PackType)PackType.SERVER_DATA, (PackSelectionConfig)selectionConfig);
        event.addRepositorySource(packConsumer -> packConsumer.accept(dataPack));
    }

    private static Pack.ResourcesSupplier createSupplier(final PackResources packResources) {
        return new Pack.ResourcesSupplier(){

            public PackResources openPrimary(PackLocationInfo locationInfo) {
                return packResources;
            }

            public PackResources openFull(PackLocationInfo locationInfo, Pack.Metadata metadata) {
                return packResources;
            }
        };
    }
}

